<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProjetDivertissementJeuneEnfant extends Model
{
    use HasFactory;

    // Nom de la table
    protected $table = 'projet_divertissement_jeune_enfant';

    // Clé primaire
    protected $primaryKey = 'id_projet';

    // Type de la clé primaire
    protected $keyType = 'int';

    // PK auto-increment
    public $incrementing = true;

    // Colonnes assignables
    protected $fillable = [
        'nature_projet_id',
        'id_directeur',
        'nbr_diplome_universitaire',
        'nbr_autre',
        'espace_spectacle',
        'caracteristique_spec',
        'espace_sportif',
        'caracteristique_sportif',
        'espace_activite_service',
        'caracteristique_activite_serv',
        'espace_activite_culturelle',
        'caracteristique_activite_cult',
        'remarques',
        'id_statut',
        'id_formulaire',
        'commentaire_motif',
        'nom_projet',
        'adresse_siege',
        'code_postal',
        'gouvernorat_id', 
		'delegation_id',
		'niveau_etude_user',
		'dernier_diplome_user',
		'experience_user',
		'id_user',
    ];

    // Timestamps automatiques
    public $timestamps = true;

    // Relations

    public function investissements()
{
    return $this->hasMany(Investissement::class, 'id_projet', 'id_projet');
}

    // Relation vers le type de projet
    public function natureProjet()
    {
        return $this->belongsTo(NatureProjet::class, 'nature_projet_id', 'id_nature_p');
    }

    // Relation vers le directeur
    public function directeur()
    {
        return $this->belongsTo(DirecteurEtablissement::class, 'id_directeur', 'id_directeur');
    }

    public function statut()
    {
        return $this->belongsTo(TpStatut::class, 'id_statut'); 
    }
	
	public function gouvernorat()
    {
        return $this->belongsTo(\App\Models\Gouvernorat::class, 'gouvernorat_id');
    }

    public function delegation()
    {
        return $this->belongsTo(\App\Models\Delegation::class, 'delegation_id');
    }
	
	public function debutActivite()
{
    return $this->hasOne(
        \App\Models\DebutActivite::class,
        'id_projet_debut',
        'id_projet'
    );
}

public function utilisateur()
    {
        return $this->belongsTo(Utilisateur::class, 'id_user', 'id');
    }
public function statutHistories()
{
    return $this->hasMany(\App\Models\ImmobilierStatutHistory::class, 'projet_id', 'id_projet')
                ->orderBy('created_at', 'desc');
}


}
