<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ImmobilierStatutHistory extends Model
{
    protected $table = 'immobilier_statut_histories';

    // autoriser l'insertion en masse des colonnes que tu utilises
    protected $fillable = [
        'immobilier_id',
        'debut_activite_id',
        'projet_id',
        'institution_id',
        'jeune_enfant_id',
        'inv_sport_id',
		'documents_formulaire_id',
		'documents_financement_list_id',
        'documents_financement_list_id2',
        'demande_manifestation_id',
        'from_statut_id',
        'to_statut_id',
        'changed_by',
        'commentaire',
    ];

    // relations
    public function immobilier() { return $this->belongsTo(Immobilier::class, 'immobilier_id', 'id_imm'); }
    public function fromStatut()  { return $this->belongsTo(TpStatut::class, 'from_statut_id', 'id_statut'); }
    public function toStatut()    { return $this->belongsTo(TpStatut::class, 'to_statut_id', 'id_statut'); }
    public function changer()     { return $this->belongsTo(\App\Models\Utilisateur::class, 'changed_by', 'id'); }
    public function debutActivite(){ return $this->belongsTo(\App\Models\DebutActivite::class, 'debut_activite_id', 'id_debut'); }
    public function jeuneEnfant() { return $this->belongsTo(\App\Models\ActiviteJeuneEnfant::class, 'jeune_enfant_id', 'id_jeune_enfant'); }
    public function projet()      { return $this->belongsTo(\App\Models\ProjetDivertissementJeuneEnfant::class, 'projet_id', 'id_projet'); }
    public function institution() { return $this->belongsTo(\App\Models\InstitutionPriveJeunesse::class, 'institution_id', 'id_inst'); }
    public function invSport()    { return $this->belongsTo(\App\Models\InvestissementSport::class, 'inv_sport_id', 'id_inv_sport'); }
	
	public function documentFormulaire()
    {
        return $this->belongsTo(\App\Models\DocumentsFormulaire::class, 'documents_formulaire_id', 'id_doc');
    }
	
	public function documentsFinancementList()
{
    return $this->belongsTo(\App\Models\DocumentsFinancementList::class, 'documents_financement_list_id', 'id_doc_list');
}
  public function documentsFinancementList2()
    {
        return $this->belongsTo(\App\Models\DocumentsFinancementList::class, 'documents_financement_list_id2', 'id_doc_list');
    }
	
}
