<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FieldValue extends Model
{
    use HasFactory;

    protected $table = 'field_values';

    protected $fillable = [
        'candidate_id',   // was concours_ext_id
        'field_definition_id',
        'value',
    ];

    public $timestamps = true;

    public function definition()
    {
        return $this->belongsTo(FieldDefinition::class, 'field_definition_id', 'id');
    }

    public function candidate()
    {
        return $this->belongsTo(Candidate::class, 'candidate_id', 'id');
    }
}
