<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Federation extends Model
{
    protected $table = 'federations';

    protected $primaryKey = 'id';

    public $timestamps = true;

    protected $fillable = [
        'user_id',
        'nom_ar',
        'nom_fr',
        'nom_en',
        'telephone',
        'telephone2',
        'president_ar',
        'president_fr',
        'president_en',
        'fax',
        'email',
        'site_web',
        'adresse_ar',
        'adresse_fr',
        'adresse_en',
        'date_creation',
        'logo',
    ];

    protected $casts = [
        'date_creation' => 'date:Y-m-d',
    ];


    
    public function user()
    {
        return $this->belongsTo(Utilisateur::class, 'user_id', 'id');
    }
}
