<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EstimationBudget extends Model
{
    use HasFactory;

    protected $table = 'estimation_budget';
    protected $primaryKey = 'id_estimation';
    public $timestamps = false;

    protected $fillable = [
        'projet_id',
        'cout_total_estime',
        'financement_propre_montant',
        'financement_propre_pourcentage',
        'aide_ministere_montant',
        'aide_ministere_pourcentage',
    ];

    public function projet()
    {
        return $this->belongsTo(Projet::class, 'projet_id', 'id_projet');
    }

    public function contributeurs()
    {
        return $this->hasMany(ContributeurProjet::class, 'id_estimation_budget', 'id_estimation');
    }

    public function postesDepense()
    {
        return $this->hasMany(PosteDepense::class, 'id_estimation_budget', 'id_estimation');
    }
    
}