<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DebutActivite extends Model
{
    protected $table = 'debut_activites';
    protected $primaryKey = 'id_debut';

    protected $fillable = [
        'immobilier_id',
        'date_debut_activite',
        'preuve_propriete_location',
        'plan_architectural',
        'declaration_investissement',
        'identification',
        'extrait_registre_national_entreprise',
        'certificat_prevention',
        'contrat_assurance',
        'approbation_autorite_minicipale',
        'id_type_formulaire',
        'commentaire_motif',
        'id_statut',
        'etat_formulaire', 
		'id_activite_jeune_enfant',
		'id_insts',
		'id_inv_sport_debut',
		'id_projet_debut',
    ];

    protected $casts = [
    'date_debut_activite' => 'datetime', 
];

    public function immobilier()
    {
        return $this->belongsTo(\App\Models\Immobilier::class, 'immobilier_id', 'id_imm');
    }

    public function utilisateur()
{
    return $this->hasOneThrough(
        \App\Models\Utilisateur::class, 
        \App\Models\Immobilier::class,  
        'id_imm',      
        'id',          
        'immobilier_id',
        'user_id'
    );
}

public function statut()
{
    return $this->belongsTo(TpStatut::class, 'id_statut'); // 'id_statut' = colonne FK
}


public function activiteJeuneEnfant()
{
    return $this->belongsTo(
        \App\Models\ActiviteJeuneEnfant::class, // Modèle parent
        'id_activite_jeune_enfant',             // FK dans debut_activites
        'id_jeune_enfant'                       // PK dans activites_jeune_enfant
    );
}

public function insts()
{
    return $this->belongsTo(
        \App\Models\InstitutionPriveJeunesse::class, // Modèle parent
        'id_insts',             // FK dans debut_activites
        'id_inst'                       // PK dans activites_jeune_enfant
    );
}
/*public function projet_debut()
{
    return $this->belongsTo(
        \App\Models\ProjetDivertissementJeuneEnfant::class, // Modèle parent
        'id_projet_debut',             // FK dans debut_activites
        'id_projet'                       // PK dans activites_jeune_enfant
    );
}*/

public function projet_debut()
{
    return $this->belongsTo(
        \App\Models\ProjetDivertissementJeuneEnfant::class,
        'id_projet_debut',
        'id_projet'
    ); 
}

public function sport()
{
    return $this->belongsTo(
        \App\Models\InvestissementSport::class, // Modèle parent
        'id_inv_sport_debut',             // FK dans debut_activites
        'id_inv_sport'                       // PK dans activites_jeune_enfant
    );
}
public function statutHistories()
    {
        return $this->hasMany(\App\Models\ImmobilierStatutHistory::class, 'debut_activite_id', 'id_debut')
                    ->orderBy('created_at', 'desc');
    }
	
	
	// Dans le modèle DebutActivite
/*public function getUtilisateurAttribute()
{
    // Priorité 1: Si c'est une activité jeune enfant
    if ($this->activiteJeuneEnfant && $this->activiteJeuneEnfant->utilisateur) {
        return $this->activiteJeuneEnfant->utilisateur;
    }
    
    // Priorité 2: Si c'est un immobilier
    if ($this->immobilier && $this->immobilier->utilisateur) {
        return $this->immobilier->utilisateur;
    }
    
    // Priorité 3: Si c'est une institution
    if ($this->insts && $this->insts->utilisateur) {
        return $this->insts->utilisateur;
    }
    
    // Priorité 4: Si c'est un projet
    if ($this->projet_debut && $this->projet_debut->utilisateur) {
        return $this->projet_debut->utilisateur;
    }
    
    // Priorité 5: Si c'est un sport
    if ($this->sport && $this->sport->utilisateur) {
        return $this->sport->utilisateur;
    }
    
    return null;
}
*/


public function getTypeFormule()
{
    if ($this->id_projet_debut) {
        return 'مشروع ترفيهي للطفل والشباب';
    } elseif ($this->id_activite_jeune_enfant) {
        return 'نشاط طفل وشباب';
    } elseif ($this->immobilier_id) {
        return 'عقاري';
    } elseif ($this->id_insts) {
        return 'مؤسسة خاصة للشباب';
    } elseif ($this->id_inv_sport_debut) {
        return 'استثمار رياضي';
    } else {
        return 'غير محدد';
    }
}



public function getUtilisateurAttribute()
{
	if ($this->projet_debut && $this->projet_debut->utilisateur) {
        return $this->projet_debut->utilisateur;
    }
	if ($this->activiteJeuneEnfant && $this->activiteJeuneEnfant->utilisateur) {
        return $this->activiteJeuneEnfant->utilisateur;
    }
    if ($this->immobilier && $this->immobilier->utilisateur) {
        return $this->immobilier->utilisateur;
    }
    if ($this->insts && $this->insts->utilisateur) {
        return $this->insts->utilisateur;
    }
    if ($this->projet_debut && $this->projet_debut->utilisateur) {
        return $this->projet_debut->utilisateur;
    }    
    if ($this->sport && $this->sport->utilisateur) {
        return $this->sport->utilisateur;
    }    
    return null;
}

}
