<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ChambreTente extends Model
{
    use HasFactory;

    protected $table = 'chambre_tente';
    protected $primaryKey = 'id_chambre_tente';
    public $timestamps = true;

    protected $fillable = [
        'capacite',
        'auberge_id',
        'type_chambre_id',
        'num_chambre',
        'type',
        'est_dispo'
    ];

    public function auberge()
    {
        return $this->belongsTo(Auberge::class, 'auberge_id', 'id');
    }

    public function reservations()
{
    return $this->hasMany(Reservation::class, 'chambre_id', 'id_chambre_tente');
}
    

    public function typeChambre()
    {
        return $this->belongsTo(TypeChambre::class, 'type_chambre_id', 'id_type');
    }

    public function disponibilites()
    {
        return $this->hasMany(Disponibilite::class, 'chambre_id', 'id_chambre_tente');
    }

    public function reservationsChambreTente()
    {
        return $this->hasMany(ReservationChambreTente::class, 'chambre_tente_id', 'id_chambre_tente');
    }


}
