<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ActivitePhase extends Model
{
    use HasFactory;

    protected $table = 'activite_phase';
    protected $primaryKey = 'id_act';
    public $timestamps = false;

    protected $fillable = [
        'id_projet',
        'description',
        'completion_date',
        'completion_location',
    ];

    public function projet()
    {
        return $this->belongsTo(Projet::class, 'id_projet', 'id_projet');
    }
}
