<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ActiviteJeuneEnfant extends Model
{
    use HasFactory;

    protected $table = 'activites_jeune_enfant';

    protected $primaryKey = 'id_jeune_enfant';

    public $incrementing = true;

    protected $keyType = 'int';

    public $timestamps = true;

    protected $fillable = [
        'nom_projet',
        'adresse_siege',
        'code_postal',
        'remarque',
        'id_formulaire',
        'id_statut',
        'id_statut_inv',
        'id_nature_activite',
        'id_gouvernorat',
        'id_delegation',
        'id_user',
        'id_municipalite',
        'commentaire_motif',
        'remarques',
		'niveau_etude_user',
		'dernier_diplome_user',
		'experience_user',
    ];


public function investissements()
    {
        return $this->hasMany(Investissement::class, 'id_jeune_enfant', 'id_jeune_enfant');
    }

    public function formulaire()
    {
        return $this->belongsTo(TpFormulaire::class, 'id_formulaire', 'id_type');
    }

    public function statut()
    {
        return $this->belongsTo(TpStatut::class, 'id_statut', 'id_statut');
    }

    public function statutInv()
    {
        return $this->belongsTo(StatutInv::class, 'id_statut_inv', 'id_status');
    }

    public function natureActivite()
    {
        return $this->belongsTo(NatureActivite::class, 'id_nature_activite', 'id_nature_ac');
    }

    public function gouvernorat()
    {
        return $this->belongsTo(Gouvernorat::class, 'id_gouvernorat', 'id_gouver');
    }

    public function delegation()
    {
        return $this->belongsTo(Delegation::class, 'id_delegation', 'id_delegation');
    }

    public function municipalite()
    {
        return $this->belongsTo(Municipalite::class, 'id_municipalite', 'id_municipalite');
    }

    public function user()
    {   
        return $this->belongsTo(Utilisateur::class, 'id_user', 'id');
    }
	
	public function debutActivites()
{
    return $this->hasMany(
        \App\Models\DebutActivite::class,   // Modèle enfant
        'id_activite_jeune_enfant',         // FK dans debut_activites
        'id_jeune_enfant'                   // PK dans activites_jeune_enfant
    );
}


public function debutActivite()
{
    return $this->hasOne(
        \App\Models\DebutActivite::class,
        'id_activite_jeune_enfant',
        'id_jeune_enfant'
    );
}

public function utilisateur()
    {
        return $this->belongsTo(Utilisateur::class, 'id_user', 'id');
    }


	
	
	
	
	
	
// in ActiviteJeuneEnfant.php (or your Projet model)
public function statutHistories()
{
    // use the jeune_enfant_id column in the history table (adjust if your PK name differs)
    return $this->hasMany(\App\Models\ImmobilierStatutHistory::class, 'jeune_enfant_id', 'id_jeune_enfant')
                ->orderBy('created_at', 'desc');
}


}
