<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use App\Models\DocumentsFinancementList;

class StatutDocumentChanged extends Mailable
{
    use Queueable, SerializesModels;

    public DocumentsFinancementList $docList;
    public string $type;   // normalized type string: accepted, rejected, incomplete, deferred, status_changed
    public array $params;  // optional extra params like reason, missing, note, date
    public $recipientUser;

    public function __construct(DocumentsFinancementList $docList, string $type = 'status_changed', array $params = [], $recipientUser = null)
    {
        $this->docList = $docList;
        $this->type = $type;
        $this->params = $params;
        $this->recipientUser = $recipientUser;
    }

    public function build()
    {
        // subject mapping (Arabic)
        $subjects = [
            'accepted'       => 'تم قبول ملفك للتمويل العمومي',
            'rejected'       => 'تم رفض ملفك للتمويل العمومي',
            'incomplete'     => 'ملفك غير مكتمل - مطلوب مستندات إضافية',
            'deferred'       => 'تأجيل معالجة ملفك للتمويل العمومي',
            'status_changed' => 'تحديث حالة ملف التمويل العمومي الخاص بك',
        ];

        $subject = $subjects[$this->type] ?? $subjects['status_changed'];

        return $this->subject($subject)
                    ->view('emails.statut_document_changed')
                    ->with([
                        'docList' => $this->docList,
                        'type'    => $this->type,
                        'params'  => $this->params,
                        'user'    => $this->recipientUser ?? $this->docList->user,
                    ]);
    }
}
