<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Carbon\Carbon;
class ReservationAcceptedMail extends Mailable
{
    use Queueable;

    public $reservation;
    public $utilisateurName;
    public $numeroDossier;
    public $dateSent;
    public $messageHtml;

    public function __construct($reservation)
    {
        $this->reservation = $reservation;
        $this->utilisateurName = optional($reservation->user)->nom_prenom ?? 'المستخدم';
        $this->numeroDossier = $reservation->formatted_dossier ?? ($reservation->id ?? '00-'.$reservation->id.'-unknown-'.now()->format('Y'));
        $this->dateSent = now()->format('Y-m-d');
        $this->messageHtml = "<p>تم قبول طلبكم بنجاح.</p><p>سيتم التواصل معكم لمزيد التفاصيل.</p>";
    }

    public function build()
    {
        return $this->subject('تم قبول الحجز')
                    ->view('emails.reservation.status')
                    ->with([
                        'utilisateur_name' => $this->utilisateurName,
                        'numero_dossier' => $this->numeroDossier,
                        'message_html' => $this->messageHtml,
                        'date_sent' => $this->dateSent,
                        'logo_url' => asset('logo.png'),
                    ]);
    }
}

