<?php
namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class JeunesseStatutMail extends Mailable
{
    use Queueable, SerializesModels;

    public $type;   // accepted|rejected|incomplete|deferred
    public $user;
    public $motif;

    public function __construct($type, $user, $motif = null)
    {
        $this->type  = $type;
        $this->user  = $user;
        $this->motif = $motif;
    }

    public function build()
    {
        switch ($this->type) {
            case 'accepted':
                $subject = 'تم قبول مشروعك في قطاع المؤسسات الخاصة بالشباب و الأطفال';
                break;
            case 'rejected':
                $subject = 'تم رفض مشروعك في قطاع المؤسسات الخاصة بالشباب و الأطفال';
                break;
            case 'incomplete':
                $subject = 'ملفك غير مكتمل — يرجى استكمال الوثائق';
                break;
            case 'deferred':
                $subject = 'تم تأجيل قرار مشروعك';
                break;
            default:
                $subject = 'تغيير حالة طلبك';
                break;
        }

        return $this->subject($subject)
                    ->view('emails.jeunesse.statut')
                    ->with([
                        'type'  => $this->type,
                        'user'  => $this->user,
                        'motif' => $this->motif,
                    ]);
    }
}
