<?php
namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class FormationStatutMail extends Mailable
{
    use Queueable, SerializesModels;

    public $type;
    public $user;
    public $motif;

    public function __construct($type, $user, $motif = null)
    {
        $this->type  = $type;   // 'accepte'|'refuse'|'incomplet'|'deferre'
        $this->user  = $user;
        $this->motif = $motif;
    }

    public function build()
    {
        $subjects = [
            'accepte'   => 'تم قبول مشروعك بالإستثمار الرياضي',
            'refuse'    => 'تم رفض مشروعك بالإستثمار الرياضي',
            'incomplet' => 'طلبك غير مكتمل — وثائق ناقصة',
            'deferre'   => 'تم إرجاء قرار طلبك - بحاجة للمداولة',
            'status_changed' => 'تحديث حالة طلبك'
        ];

        $subject = $subjects[$this->type] ?? $subjects['status_changed'];

        return $this->subject($subject)
                    ->to($this->user->email)
                    ->view('emails.formation_stage.statut')
                    ->with([
                        'type'  => $this->type,
                        'user'  => $this->user,
                        'motif' => $this->motif,
                    ]);
    }
}
