<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class DebutActiviteStatutMail extends Mailable
{
    use Queueable, SerializesModels;

    public $type;
    public $user;
    public $commentaire;
    public $dateDebut;

    /**
     * $type: 'accepte'|'refuse'|'incomplet'|'deferre'
     * $commentaire: optional string
     * $dateDebut: optional Carbon or date string (for accepted)
     */
    public function __construct(string $type, $user, $commentaire = null, $dateDebut = null)
    {
        $this->type = $type;
        $this->user = $user;
        $this->commentaire = $commentaire;
        $this->dateDebut = $dateDebut ? ( $dateDebut instanceof \Carbon\Carbon ? $dateDebut : \Carbon\Carbon::parse($dateDebut) ) : null;
    }

    public function build()
    {
        return $this->subject('تحديث حالة الطلب')
                    ->view('emails.salle_sport.debut_activite');
    }
}
