<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB; // <-- CORRECT
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;

use App\Notifications\ReservationAcceptedNotification;
use App\Notifications\ReservationRejectedNotification;
use App\Mail\ReservationAcceptedMail;
use App\Mail\ReservationRejectedMail;
use Illuminate\Support\Facades\Auth;
use App\Models\MilieuAuberge;
use App\Models\Auberge;
use App\Models\Gouvernorat;
use App\Models\TpSportsAuberge;
use App\Models\TpServiceAuberge;
use App\Models\Delegation;
use App\Models\Reservation;
use App\Models\ChambreTente;
use App\Models\HistoriqueReservation;
use App\Models\ReservationChambreTente;
use App\Models\ReservationPerson;
use App\Models\RestaurationAuberge;

class ReservationAubergesController extends Controller
{
    /*public function index()
{
    $user = Auth::user(); 

    $query = Reservation::with(['auberge', 'statut', 'user'])
	->orderBy('created_at', 'desc');

    if ($user->roles->pluck('id_roles')->contains(7)) {
        $query->where('id_auberge', $user->auberge_id);
    }

    $reservations = $query->paginate(10);

    return view('backoffice.auberges.reservation.index', compact('reservations'));
}*/


public function index(Request $request)
{
    $user = Auth::user();

    // Récupérer la recherche et la nettoyer
    $search = trim((string) $request->input('q', ''));

    // Bloquer recherches vides ou contenant seulement % et espaces
    if ($search === '' || preg_match('/^[\s%]+$/', $search)) {
        $search = null;
    }

    $query = Reservation::with(['auberge', 'statut', 'user'])
                        ->orderBy('created_at', 'desc');

    // Si l'utilisateur est lié à un auberge spécifique
    if ($user->roles->pluck('id_roles')->contains(7)) {
        $query->where('id_auberge', $user->auberge_id);
    }

    // Recherche avancée
    if ($search) {
        $words = preg_split('/\s+/', $search);

        $query->where(function ($q) use ($words) {
            foreach ($words as $word) {
                // Échapper % et _ pour LIKE
                $word = str_replace(['\\', '%', '_'], ['\\\\', '\\%', '\\_'], $word);

                $q->where(function ($qq) use ($word) {
                    $qq->whereHas('user', function($qUser) use ($word) {
                        $qUser->where('nom_prenom', 'like', "%{$word}%");
                    })
                    ->orWhereHas('auberge', function($qAub) use ($word) {
                        $qAub->where('nom_ar', 'like', "%{$word}%")
                              ->orWhere('nom_fr', 'like', "%{$word}%")
                              ->orWhere('nom_en', 'like', "%{$word}%");
                    })
                    ->orWhere('date_reserv', 'like', "%{$word}%")
                    ->orWhere('date_arrive', 'like', "%{$word}%")
                    ->orWhere('date_depart', 'like', "%{$word}%");
                });
            }
        });
    }

    $reservations = $query->paginate(10)->withQueryString();

    return view('backoffice.auberges.reservation.index', compact('reservations', 'search'));
}



    /*public function show(Reservation $reservation)
    {
        $restaurations = $reservation->restaurations;
         
        return view('backoffice.auberges.reservation.show', compact('reservation', 'restaurations'));
    }*/
	
	/*public function show(Reservation $reservation)
{
    

	foreach (auth()->user()->unreadNotifications as $notif) {
		if (isset($notif->data['reservation_id']) 
			&& $notif->data['reservation_id'] == $reservation->id) {

			$notif->markAsRead();
		}
	}

    $restaurations = $reservation->restaurations;

    return view('backoffice.auberges.reservation.show', compact('reservation', 'restaurations'));
}*/


	public function show(Reservation $reservation)
	{
		// Mark related notifications as read
		foreach (auth()->user()->unreadNotifications as $notif) {
			if (isset($notif->data['reservation_id']) 
				&& $notif->data['reservation_id'] == $reservation->id_reserv) { // تأكد من استخدام المفتاح الصحيح
				
				$notif->markAsRead();
			}
		}

		// تحميل العلاقات اللازمة مع العلاقات المتداخلة
		$reservation->load([
			'auberge',
			'statut',
			'user',
			'restaurations',
			'reservationPersons.typeTarif' // إضافة هذه العلاقة
		]);

		// الحصول على خدمات الطعام المتاحة لهذه المؤسسة
		$restaurations = RestaurationAuberge::where('auberge_id', $reservation->id_auberge)->get();

		return view('backoffice.auberges.reservation.show', compact('reservation', 'restaurations'));
	}

	
	
public function updateStatus(Request $request, $id)
{
    $request->validate([
        'statut_id' => 'required|in:1,3',
        'commentaire_motif' => 'required_if:statut_id,3',
    ]);

    $reservation = Reservation::findOrFail($id);
    $reservation->statut_id = $request->statut_id;
    if ($request->statut_id == 3) {
        $reservation->commentaire_motif = $request->commentaire_motif;
    }
    $reservation->save();

    $user = $reservation->user;

    // common translation params (include dossier reference)
    $idPad = str_pad($reservation->id, 3, '0', STR_PAD_LEFT);
    $cin = $reservation->user->num_cin ?? $reservation->user->cin ?? null;
    $cinDigits = $cin ? preg_replace('/\D+/', '', $cin) : '';
    $cinPad = $cinDigits ? str_pad($cinDigits, 9, '0', STR_PAD_LEFT) : '000000000';
    $year = $reservation->created_at ? $reservation->created_at->format('Y') : now()->format('Y');
    $reference = "{$idPad}-{$cinPad}-{$year}";

    if ($request->statut_id == 1) {
        // translation params for accepted
        $params = [
            'date' => now()->format('Y-m-d'),
            'reference' => $reference,
            'object' => $reservation->objet ?? '',
        ];

        // DB notification using translation
        if ($user) {
            $user->notify(new ReservationAcceptedNotification($reservation, $params));
        }

        // Mail (unchanged behaviour)
        try {
            Mail::to($user->email)->send(new ReservationAcceptedMail($reservation));
        } catch (\Exception $e) {
            Log::error('Erreur envoi mail acceptation: '.$e->getMessage(), ['reservation_id'=>$reservation->id]);
        }
    }

    if ($request->statut_id == 3) {
        $motif = $request->commentaire_motif;

        $params = [
            'reason' => $motif,
            'reference' => $reference,
            'object' => $reservation->objet ?? '',
            'date' => now()->format('Y-m-d'),
        ];

        if ($user) {
            $user->notify(new ReservationRejectedNotification($reservation, $motif, $params));
        }

        try {
            Mail::to($user->email)->send(new ReservationRejectedMail($reservation, $motif));
        } catch (\Exception $e) {
            Log::error('Erreur envoi mail refus: '.$e->getMessage(), ['reservation_id'=>$reservation->id]);
        }
    }

    return back()->with('success', 'تم تحديث وضعية الحجز بنجاح');
}


    public function affecterChambres($id)
    {
        $reservation = Reservation::with('auberge')->findOrFail($id);
        $chambres = ChambreTente::where('auberge_id', $reservation->id_auberge)
                    ->where('est_dispo', 1)
                    ->get();
        $male = $reservation->nbr_h ?? 0;
        $female = $reservation->nbr_f ?? 0;
        return view('backoffice.auberges.reservation.affecter_chambres',
            compact('reservation', 'chambres', 'male', 'female')
        );
    }

    public function assignChambre(Request $request, $id)
    {
        $reservation = Reservation::findOrFail($id);
        $request->validate([
            'chambre_id' => 'required|exists:chambre_tente,id_chambre_tente',
            'male_personnes' => 'required|integer|min:0',
            'female_personnes' => 'required|integer|min:0',
        ]);
        $total = $request->male_personnes + $request->female_personnes;
        $chambre = ChambreTente::findOrFail($request->chambre_id);
        $deja_affecte = ReservationChambreTente::where('chambre_tente_id', $chambre->id_chambre_tente)
                            ->sum('total_personnes');
        $capacite_restante = $chambre->capacite - $deja_affecte;
        if ($total > $capacite_restante) {
            return back()->withErrors([
                'total' => "❗ العدد يتجاوز الطاقة المتبقية في هذه الغرفة ($capacite_restante)"
            ]);
        }
        ReservationChambreTente::create([
            'reservation_id' => $reservation->id_reserv,
            'chambre_tente_id' => $chambre->id_chambre_tente,
            'male_personnes' => $request->male_personnes,
            'female_personnes' => $request->female_personnes,
            'total_personnes' => $total,
            'capacite_restante' => $capacite_restante - $total,
        ]);
        return back()->with('success', '✔ تم تعيين الأشخاص في الغرفة بنجاح');
    }

    /*public function viderToutesChambres($reservationId)
    {
        $reservation = Reservation::findOrFail($reservationId);
        $affectations = ReservationChambreTente::where('reservation_id', $reservationId)->get();
        if ($affectations->isEmpty()) {
            DB::table('historique_reservation')->insert([
                'reservation_id'   => $reservation->id_reserv,
                'date_arrive'      => $reservation->date_arrive,
                'date_depart'      => $reservation->date_depart,
                'date_reserv'      => $reservation->date_reserv,
                'nbr_personnes'    => $reservation->nbr_personnes,
                'nbr_f'            => $reservation->nbr_f,
                'nbr_h'            => $reservation->nbr_h,
                'total_price'      => $reservation->total_price,
                'user_id'          => $reservation->user_id,
                'statut_id'        => $reservation->statut_id,
                'id_auberge'       => $reservation->id_auberge,
                'remarque'         => $reservation->remarque,
                'commentaire_motif'=> $reservation->commentaire_motif,
                'action'           => 'suppression',
                'created_at'       => now(),
            ]);

            $reservation->delete();
            return redirect()->route('reservation.index')->with('success', '✔ تم حذف الحجز بنجاح.');
        }
        foreach ($affectations as $aff) {

            DB::table('historique_chambres')->insert([
                'reservation_id'   => $aff->reservation_id,
                'chambre_tente_id' => $aff->chambre_tente_id,
                'male_personnes'   => $aff->male_personnes,
                'female_personnes' => $aff->female_personnes,
                'total_personnes'  => $aff->total_personnes,
                'date_arrive'      => $reservation->date_arrive,
                'date_depart'      => $reservation->date_depart,
                'action'           => 'suppression totale الحجز',
                'created_at'       => now(),
            ]);
            ChambreTente::where('id_chambre_tente', $aff->chambre_tente_id)
                ->update(['est_dispo' => 1]);
        }
        ReservationChambreTente::where('reservation_id', $reservationId)->delete();
        DB::table('historique_reservation')->insert([
            'reservation_id'   => $reservation->id_reserv,
            'date_arrive'      => $reservation->date_arrive,
            'date_depart'      => $reservation->date_depart,
            'date_reserv'      => $reservation->date_reserv,
            'nbr_personnes'    => $reservation->nbr_personnes,
            'nbr_f'            => $reservation->nbr_f,
            'nbr_h'            => $reservation->nbr_h,
            'total_price'      => $reservation->total_price,
            'user_id'          => $reservation->user_id,
            'statut_id'        => $reservation->statut_id,
            'id_auberge'       => $reservation->id_auberge,
            'remarque'         => $reservation->remarque,
            'commentaire_motif'=> $reservation->commentaire_motif,
            'action'           => 'suppression',
            'created_at'       => now(),
        ]);
        $reservation->delete();
        return redirect()->route('reservation.index')
                        ->with('success', '✔ تم إفراغ الغرف وحذف الحجز وأرشفتها بنجاح.');
    }*/




public function viderToutesChambres($reservationId)
{
        $reservation = Reservation::findOrFail($reservationId);

    $affectations = ReservationChambreTente::where('reservation_id', $reservationId)->get();

    $historiqueReservationId = DB::table('historique_reservation')->insertGetId([
        'reservation_id'    => $reservation->id_reserv,
        'date_arrive'       => $reservation->date_arrive,
        'date_depart'       => $reservation->date_depart,
        'date_reserv'       => $reservation->date_reserv,
        'nbr_personnes'     => $reservation->nbr_personnes,
        'nbr_f'             => $reservation->nbr_f,
        'nbr_h'             => $reservation->nbr_h,
        'total_price'       => $reservation->total_price,
        'user_id'           => $reservation->user_id,
        'statut_id'         => $reservation->statut_id,
        'id_auberge'        => $reservation->id_auberge,
        'remarque'          => $reservation->remarque,
        'commentaire_motif' => $reservation->commentaire_motif,
        'action'            => 'suppression',
        'created_at'        => now(),
        'updated_at'        => now(),
    ]);

    foreach ($affectations as $aff) {
        DB::table('historique_chambres')->insert([
            'historique_reservation_id' => $historiqueReservationId,
            'reservation_id'            => $aff->reservation_id,
            'chambre_tente_id'          => $aff->id,
            'male_personnes'            => $aff->male_personnes,
            'female_personnes'          => $aff->female_personnes,
            'total_personnes'           => $aff->total_personnes,
            'date_arrive'               => $reservation->date_arrive,
            'date_depart'               => $reservation->date_depart,
            'action'                    => 'suppression totale الحجز',
            'created_at'                => now(),
            'updated_at'                => now(),
        ]);

        ChambreTente::where('id_chambre_tente', $aff->chambre_tente_id)
            ->update(['est_dispo' => 1]);
    }

    $restaurations = DB::table('reservation_restauration')
        ->where('reservation_id', $reservationId)
        ->get();

    foreach ($restaurations as $restauration) {
        DB::table('historique_reservation_restauration')->insert([
            'reservation_id'            => $restauration->reservation_id,
            'historique_reservation_id' => $historiqueReservationId,
            'restauration_id'           => $restauration->restauration_id,
            'tarif'                     => $restauration->tarif,
            'created_at'                => now(),
            'updated_at'                => now(),
        ]);
    }

    ReservationChambreTente::where('reservation_id', $reservationId)->delete();
    DB::table('reservation_restauration')->where('reservation_id', $reservationId)->delete();
    $reservation->delete();

    return redirect()->route('reservation.index')
        ->with('success', '✔ تم إفراغ الغرف، حذف الحجز وأرشفة جميع البيانات بنجاح.');
}


    public function archives()
    {
        $reservations = HistoriqueReservation::with(['utilisateur', 'auberge'])
            ->orderBy('id', 'desc')
            ->paginate(10);

        return view('backoffice.auberges.reservation.archives', compact('reservations'));
    }


   

    public function showArchive($id)
    {
        $reservation = HistoriqueReservation::with([
            'utilisateur',
            'auberge',
            'historiqueChambres.chambreTente', 
            'restaurations'
        ])->find($id);

        if (!$reservation) {
            abort(404);
        }

        $affectations = $reservation->historiqueChambres; 

        return view('backoffice.auberges.reservation.show_archive', compact('reservation', 'affectations'));
    }






}
