<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use App\Models\PasswordReset; 

class PasswordController extends Controller
{
    public function showSetupForm($token)
    {
        $record = PasswordReset::where('token', $token)->firstOrFail();
        return view('auth.setup_password', ['token' => $token, 'email' => $record->email]);
    }

    public function setupPassword(Request $request)
    {
        $request->validate([
            'token' => 'required',
            'password' => 'required|confirmed|min:8',
        ]);

        $record = PasswordReset::where('token', $request->token)->firstOrFail();
        $user = User::where('email', $record->email)->firstOrFail();
        $user->password = Hash::make($request->password);
        $user->save();

        $record->delete();

        return redirect()->route('login')->with('status', 'تم إعداد كلمة المرور بنجاح! يمكنك الآن تسجيل الدخول.');
    }
}