<?php

namespace App\Http\Controllers\Investissement;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Models\TypeFormulaire;
use App\Models\TypeEspaceS;
use App\Models\Utilisateur;
use App\Models\InvestissementSport;
use App\Models\DirecteurEtablissement;
use App\Models\Investissement;
use App\Mail\FormationStatutMail;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;
use Carbon\Carbon;
use App\Notifications\FormationStatutNotification;

use App\Models\NatureProjet; 
use App\Models\SecteurFinancement;
use App\Models\TypeEspaceInstitution;
use App\Models\ServiceInstitution;
use App\Models\SourceFinancement;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Mpdf\Mpdf;
use App\Models\TpStatut;
use Illuminate\Support\Facades\Auth;
use App\Models\ImmobilierStatutHistory;
class FormationStageController extends Controller
{			public function index(Request $request){    
    $query = InvestissementSport::with([       
         'directeur',          'statut',      
           'natureProjet',        'investissements',    
               'investissements.utilisateur'    ]);   
                if ($request->search_option == "nom") {     
                       $nom = trim($request->nom);        
                           if (   
                                 $nom === "" ||                              $nom === "%" ||                              $nom === "%%" ||                           preg_match('/^[^a-zA-Zأ-ي0-9]+$/u', $nom)         ) {            $query->whereRaw('1 = 0');         } else {            $query->whereHas('investissements.utilisateur', function ($q) use ($nom) {                $q->where('nom_prenom', 'LIKE', "%$nom%");            });        }    }        if ($request->search_option == "nature" && $request->filled('nature')) {        $query->where('nature_projet_id', $request->nature);    }        if ($request->search_option == "identite" && $request->filled('type_identite')) {        if ($request->type_identite == 1 && $request->filled('cin')) {            $cin = trim($request->cin);            if ($cin === "" || preg_match('/[^0-9]/', $cin)) {                $query->whereRaw('1 = 0');             } else {                $query->whereHas('investissements.utilisateur', fn($q) =>                    $q->where('cin', $cin)                );            }        }        if ($request->type_identite == 2 && $request->filled('passport')) {            $passport = trim($request->passport);            if ($passport === "" || $passport === "%" || $passport === "%%") {                $query->whereRaw('1 = 0');            } else {                $query->whereHas('investissements.utilisateur', fn($q) =>                    $q->where('passport', $passport)                );            }        }        if ($request->type_identite == 3 && $request->filled('num_fiscal')) {            $num = trim($request->num_fiscal);            if ($num === "" || preg_match('/[^0-9]/', $num)) {                $query->whereRaw('1 = 0');            } else {                $query->whereHas('investissements.utilisateur', fn($q) =>                    $q->where('num_fiscal', $num)                );            }        }    }    $formations = $query->orderByDesc('created_at')                     ->paginate(10)                     ->withQueryString();    $natures = NatureProjet::all();    return view('backoffice.investissement.gestion_formation_stage.index', compact('formations', 'natures'));}


public function exportExcel(Request $request)
{
    // 🔹 نفس query متاع index
    $query = InvestissementSport::with([
        'statut',
        'natureProjet',
        'investissements',
        'investissements.utilisateur'
    ]);

    // 🔍 Filtre nom
    if ($request->search_option == "nom") {
        $nom = trim($request->nom);

        if ($nom === "" || $nom === "%" || $nom === "%%" || preg_match('/^[^a-zA-Zأ-ي0-9]+$/u', $nom)) {
            $query->whereRaw('1 = 0');
        } else {
            $query->whereHas('investissements.utilisateur', function ($q) use ($nom) {
                $q->where('nom_prenom', 'LIKE', "%$nom%");
            });
        }
    }

    // 🔍 Nature
    if ($request->search_option == "nature" && $request->filled('nature')) {
        $query->where('nature_projet_id', $request->nature);
    }

    // 🔍 Identité
    if ($request->search_option == "identite" && $request->filled('type_identite')) {

        if ($request->type_identite == 1 && $request->filled('cin')) {
            $query->whereHas('investissements.utilisateur', fn($q) =>
                $q->where('cin', trim($request->cin))
            );
        }

        if ($request->type_identite == 2 && $request->filled('passport')) {
            $query->whereHas('investissements.utilisateur', fn($q) =>
                $q->where('passport', trim($request->passport))
            );
        }

        if ($request->type_identite == 3 && $request->filled('num_fiscal')) {
            $query->whereHas('investissements.utilisateur', fn($q) =>
                $q->where('num_fiscal', trim($request->num_fiscal))
            );
        }
    }

    // ❌ بدون paginate
    $formations = $query->orderByDesc('created_at')->get();

    // 📊 Excel
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->setRightToLeft(true);

    // Header
    $sheet->fromArray([
        'المعرف',
        'الاسم و اللقب',
        'طبيعة المشروع',
        'وضعية الطلب'
    ], null, 'A1');

    $sheet->getStyle('A1:D1')->getFont()->setBold(true);

    // Data
    $row = 2;
    foreach ($formations as $formation) {
        $sheet->setCellValue("A$row", $formation->id_inv_sport);
        $sheet->setCellValue("B$row", $formation->investissements->first()?->utilisateur?->nom_prenom ?? '---');
        $sheet->setCellValue("C$row", $formation->natureProjet?->nature_ar ?? '---');
        $sheet->setCellValue("D$row", $formation->statut?->statut_ar ?? 'في الانتظار');
        $row++;
    }

    foreach (range('A', 'D') as $col) {
        $sheet->getColumnDimension($col)->setAutoSize(true);
    }

    $writer = new Xlsx($spreadsheet);
    $fileName = 'investissements_sport_' . now()->format('Ymd_His') . '.xlsx';

    return response()->streamDownload(function () use ($writer) {
        $writer->save('php://output');
    }, $fileName);
}




public function exportPdf(Request $request)
{
    // نفس query
    $query = InvestissementSport::with([
        'statut',
        'natureProjet',
        'investissements',
        'investissements.utilisateur'
    ]);

    // نفس filtres (copie exacte من index)
    if ($request->search_option == "nom") {
        $nom = trim($request->nom);

        if ($nom === "" || $nom === "%" || $nom === "%%" || preg_match('/^[^a-zA-Zأ-ي0-9]+$/u', $nom)) {
            $query->whereRaw('1 = 0');
        } else {
            $query->whereHas('investissements.utilisateur', fn($q) =>
                $q->where('nom_prenom', 'LIKE', "%$nom%")
            );
        }
    }

    if ($request->search_option == "nature" && $request->filled('nature')) {
        $query->where('nature_projet_id', $request->nature);
    }

    if ($request->search_option == "identite" && $request->filled('type_identite')) {
        if ($request->type_identite == 1 && $request->filled('cin')) {
            $query->whereHas('investissements.utilisateur', fn($q) =>
                $q->where('cin', trim($request->cin))
            );
        }
    }

    $formations = $query->orderByDesc('created_at')->get();

    $html = view(
        'backoffice.investissement.gestion_formation_stage.exports.pdf',
        compact('formations')
    )->render();

    $mpdf = new Mpdf([
        'mode' => 'utf-8',
        'format' => 'A4',
        'default_font' => 'dejavusans',
        'directionality' => 'rtl'
    ]);

    $mpdf->WriteHTML($html);

    return response($mpdf->Output('investissements_sport.pdf', 'S'))
        ->header('Content-Type', 'application/pdf');
}

    public function create()
    {
        $formulaire = TypeFormulaire::find(5);
        $types_espace_es = TypeEspaceS::all();

        $types_espace = TypeEspaceInstitution::all();
        $nature_projet = NatureProjet::all();
        $secteurs = SecteurFinancement::all();
        $service_inst = ServiceInstitution::all();
        $source_fin = SourceFinancement::all();



        return view('backoffice.investissement.gestion_formation_stage.create', compact(
            'formulaire','types_espace_es', 'types_espace','service_inst','secteurs',
            'nature_projet','source_fin'
        ));
    }



    public function pdf($id)
    {
        
        $formation = InvestissementSport::with([
            'investissements',
            'directeur',
            'investissements.utilisateur'
        ])->findOrFail($id);

        $formulaire = TypeFormulaire::find(5);
        $types_espace_es = TypeEspaceS::all();
        $types_espace = TypeEspaceInstitution::all();
        $nature_projet = NatureProjet::all();
        $secteurs = SecteurFinancement::all();
        $service_inst = ServiceInstitution::all();
        $source_fin = SourceFinancement::all();

       
         $lang = 'ar';
    $direction = 'rtl';

        
        $html = view(
            'backoffice.investissement.gestion_formation_stage.pdf', 
            compact(
                'formation',
                'formulaire',
                'types_espace_es',
                'types_espace',
                'service_inst',
                'secteurs',
                'nature_projet',
                'source_fin',
                'direction',
                'lang'
            )
        )->render();

        
        $mpdf = new \Mpdf\Mpdf([
            'mode'              => 'utf-8',
            'format'            => 'A4',
            'default_font'      => 'dejavusans',
            'directionality'    => $direction,
            'autoScriptToLang'  => true,
            'autoLangToFont'    => true,
            'margin_top'        => 15,
            'margin_bottom'     => 15,
            'margin_left'       => 12,
            'margin_right'      => 12,
        ]);

        $mpdf->SetFooter('{PAGENO} / {nbpg}');

        $mpdf->WriteHTML($html);

        return $mpdf->Output(
            'formation_'.$id.'.pdf',
            'I'
        );
    }




    public function store(Request $request)
    {
        DB::beginTransaction();
        try {
            $request->validate([
                // Investisseur
                'nom_prenom'       => 'required|string|max:255',
                'adresse'          => 'nullable|string|max:255',
                'lieu_naissance'   => 'nullable|string|max:100',
                'date_naissance'   => 'nullable|date',
                'niveau_etude'     => 'nullable|string|max:100',
                'dernier_diplome'  => 'nullable|string|max:100',
                'experience'       => 'nullable|string|max:100',

                // Directeur
                'nom_prenom_d'     => 'required|string|max:255',
                'num_cin'          => 'required|string|max:20',
                'date_delivrance'  => 'required|date',
                'lieu_delivrance'  => 'required|string|max:255',
                'niveau_etude'     => 'nullable|string|max:255',
                'dernier_diplome_obtenu' => 'nullable|string|max:255',

                // Investissements (financement)
                'investissements.*.secteur_invest_id'     => 'required|integer|exists:tp_secteur_financement,id_secteur',
                'investissements.*.montant_inv'           => 'required|numeric',
                'investissements.*.id_source_financement' => 'required|integer|exists:tp_source_financement,id_source',
                'investissements.*.montant_fin'           => 'required|numeric',

                // Investissement Sport
                'id_formulaire'   => 'required|integer|exists:tp_type_formulaire,id_type',
                'id_statut'       => 'nullable|integer|in:1,2,3',
                'type_espace_s_id'=> 'required|integer|exists:tp_type_espace_s,id_type_es',
                'nbr_chambre'     => 'nullable|integer',
                'nbr_stade'       => 'nullable|integer',
                'nbr_stages_sportifs' => 'nullable|integer',
                'nbr_salles'      => 'nullable|integer',
                'nbr_vestiaire'   => 'nullable|integer',
                'nbr_salle_renforcement_musculaire' => 'nullable|integer',
                'capacite_accueil_foyer' => 'nullable|integer',
                'capacite_accueil_stade' => 'nullable|integer',
                'heberg_rest'     => 'nullable|boolean',
                'stage_activ'     => 'nullable|boolean',
                'espace_exercice' => 'nullable|boolean',
                'activite_culturel' => 'nullable|boolean',
                'manifestation_sportif' => 'nullable|boolean',
                'autres'          => 'nullable|boolean',
                'autres_services' => 'nullable|string|max:200',
                'nom_projet'      => 'nullable|string|max:100',
                'nature_projet_id'=> 'nullable|integer|exists:tp_nature_projet,id_nature_p',
                'nbr_emplois'     => 'nullable|integer',
                'remarques'       => 'nullable|string',
                'commentaire_motif' => 'nullable|string',
            ]);

            $utilisateur = Utilisateur::create([
                'nom_prenom'     => $request->nom_prenom,
                'adresse'        => $request->adresse,
                'lieu_naissance' => $request->lieu_naissance,
                'date_naissance' => $request->date_naissance,
                'niveau_etude'   => $request->niveau_etude,
                'dernier_diplome'=> $request->dernier_diplome,
                'experience'     => $request->experience,
            ]);

            $directeur = DirecteurEtablissement::create([
                'nom_prenom_d'          => $request->nom_prenom_d,
                'num_cin'               => $request->num_cin,
                'date_delivrance'       => $request->date_delivrance,
                'lieu_delivrance'       => $request->lieu_delivrance,
                'niveau_etude'          => $request->niveau_etude,
                'dernier_diplome_obtenu'=> $request->dernier_diplome_obtenu,
            ]);

            $formation = InvestissementSport::create([
                'id_formulaire'  => $request->id_formulaire,
                'id_statut'      => $request->id_statut ?? 2,
                'type_espace_s_id' => $request->type_espace_s_id,
                'nbr_chambre'    => $request->nbr_chambre,
                'nbr_stade'      => $request->nbr_stade,
                'nbr_stages_sportifs' => $request->nbr_stages_sportifs,
                'nbr_salles'     => $request->nbr_salles,
                'nbr_vestiaire'  => $request->nbr_vestiaire,
                'nbr_salle_renforcement_musculaire' => $request->nbr_salle_renforcement_musculaire,
                'capacite_accueil_foyer' => $request->capacite_accueil_foyer,
                'capacite_accueil_stade' => $request->capacite_accueil_stade,
                'heberg_rest'    => $request->heberg_rest,
                'stage_activ'    => $request->stage_activ,
                'espace_exercice'=> $request->espace_exercice,
                'activite_culturel' => $request->activite_culturel,
                'manifestation_sportif' => $request->manifestation_sportif,
                'autres'         => $request->autres,
                'autres_services'=> $request->autres_services,
                'nom_projet'     => $request->nom_projet,
                'nature_projet_id' => $request->nature_projet_id,
                'nbr_emplois'    => $request->nbr_emplois,
                'directeur_etabl_id' => $directeur->id_directeur,
                'remarques'      => $request->remarques,
                'commentaire_motif' => $request->commentaire_motif,
            ]);

            if ($request->has('investissements')) {
                foreach ($request->investissements as $inv) {
                    Investissement::create([
                        'user_id'            => $utilisateur->id,
                        'id_inv_sport'       => $formation->id_inv_sport, 
                        'secteur_invest_id'  => $inv['secteur_invest_id'],
                        'montant_inv'        => $inv['montant_inv'],
                        'id_source_financement' => $inv['id_source_financement'] ?? null,
                        'montant_fin'        => $inv['montant_fin'] ?? null,
                    ]);
                }
            }

            DB::commit();
        return redirect()->route('admin.formation.index')
            ->with('success', ' تمّ تسجيل الإستثمار الرياضي بنجاح');

        } catch (\Exception $e) {
            DB::rollBack();
            return back()->withErrors(['error' => " خطأ أثناء التسجيل : " . $e->getMessage()])
                        ->withInput();
        }

    }

    public function edit($id)
    {
        $formation = InvestissementSport::with(['investissements', 'directeur', 'investissements.utilisateur'])->findOrFail($id);

        $formulaire = TypeFormulaire::find(5);
        $types_espace_es = TypeEspaceS::all();
        $types_espace = TypeEspaceInstitution::all();
        $nature_projet = NatureProjet::all();
        $secteurs = SecteurFinancement::all();
        $service_inst = ServiceInstitution::all();
        $source_fin = SourceFinancement::all();
        $statuts = \App\Models\TpStatut::all(); 
        return view('backoffice.investissement.gestion_formation_stage.edit', compact(
            'formation','formulaire','types_espace_es','types_espace',
            'service_inst','secteurs','nature_projet','source_fin','statuts'
        ));
    }

public function update(Request $request, $id)
{
    DB::beginTransaction();

    try {
        $request->validate([
            // Investisseur
            'nom_prenom'       => 'required|string|max:255',
            'adresse'          => 'nullable|string|max:255',
            'lieu_naissance'   => 'nullable|string|max:100',
            'date_naissance'   => 'nullable|date',
            'niveau_etude_user'     => 'nullable|string|max:100',
				'dernier_diplome_user'  => 'nullable|string|max:100',
				'experience_user'       => 'nullable|string|max:150',

            // Directeur
            'nom_prenom_d'     => 'required|string|max:255',
            'num_cin'          => 'required|string|max:20',
            'date_delivrance'  => 'required|date',
            'lieu_delivrance'  => 'required|string|max:255',
            'niveau_etude'     => 'nullable|string|max:255',
            'dernier_diplome_obtenu' => 'nullable|string|max:255',

            // Investissements (financement)
            'investissements.*.secteur_invest_id'     => 'required|integer|exists:tp_secteur_financement,id_secteur',
            'investissements.*.montant_inv'           => 'required|numeric',
            'investissements.*.id_source_financement' => 'required|integer|exists:tp_source_financement,id_source',
            'investissements.*.montant_fin'           => 'required|numeric',

            // Investissement Sport
            'id_formulaire'   => 'required|integer|exists:tp_type_formulaire,id_type',
            'id_statut'       => 'nullable|integer|in:1,2,3,4,5',
            'type_espace_s_id'=> 'required|integer|exists:tp_type_espace_s,id_type_es',
            'nbr_chambre'     => 'nullable|integer',
            'nbr_stade'       => 'nullable|integer',
            'nbr_stages_sportifs' => 'nullable|integer',
            'nbr_salles'      => 'nullable|integer',
            'nbr_vestiaire'   => 'nullable|integer',
            'nbr_salle_renforcement_musculaire' => 'nullable|integer',
            'capacite_accueil_foyer' => 'nullable|integer',
            'capacite_accueil_stade' => 'nullable|integer',
            'heberg_rest'     => 'nullable|boolean',
            'stage_activ'     => 'nullable|boolean',
            'espace_exercice' => 'nullable|boolean',
            'activite_culturel' => 'nullable|boolean',
            'manifestation_sportif' => 'nullable|boolean',
            'autres'          => 'nullable|boolean',
            'autres_services' => 'nullable|string|max:200',
            'nom_projet'      => 'nullable|string|max:100',
            'nature_projet_id'=> 'nullable|integer|exists:tp_nature_projet,id_nature_p',
            'nbr_emplois'     => 'nullable|integer',
            'remarques'       => 'nullable|string',
            'commentaire_motif'       => 'nullable|string',
        ]);

        // load model + relations
        $formation = InvestissementSport::with(['directeur','investissements','investissements.utilisateur'])
            ->findOrFail($id);

        $utilisateur = $formation->investissements->first()?->utilisateur;

        // status & comment extraction
        $oldStatus = (int) ($formation->id_statut ?? 0);
        $newStatus = $request->has('id_statut') ? (int) $request->input('id_statut') : $oldStatus;

        $commentRefus   = $request->input('commentaire_refus');
        $commentStatus  = $request->input('commentaire_status');
        $commentGeneric = $request->input('commentaire_motif');
        $commentAccept  = $request->input('commentaire_acceptation');
        $commentAvis    = $request->input('commentaire_avis');

        $comment = null;
        if ($newStatus === 3) {
            $comment = is_string($commentRefus) ? trim($commentRefus) : null;
        } elseif (in_array($newStatus, [4,5])) {
            $comment = is_string($commentStatus) ? trim($commentStatus)
                     : (is_string($commentAccept) ? trim($commentAccept) : (is_string($commentAvis) ? trim($commentAvis) : null));
        } else {
            $comment = is_string($commentGeneric) && $commentGeneric !== '' ? trim($commentGeneric) : null;
        }
        if ($comment === '') {
            $comment = null;
        }

        // create history row if status changed
        if ($oldStatus !== $newStatus) {
            $hist = new ImmobilierStatutHistory([
                'inv_sport_id'   => $formation->id_inv_sport,
                'from_statut_id' => $oldStatus ?: null,
                'to_statut_id'   => $newStatus ?: null,
                'changed_by'     => Auth::id() ?? null,
                'commentaire'    => $comment,
            ]);

            $saved = $hist->save();

            if (! $saved) {
                \Log::error('Impossible de sauvegarder ImmobilierStatutHistory', [
                    'inv_sport_id' => $formation->id_inv_sport,
                    'from' => $oldStatus,
                    'to' => $newStatus,
                    'user' => Auth::id(),
                ]);
            }
        }

        // update utilisateur (if exists)
        if ($utilisateur) {
            $utilisateur->update([
                'nom_prenom' => $request->nom_prenom,
                'adresse' => $request->adresse,
                'lieu_naissance' => $request->lieu_naissance,
                'date_naissance' => $request->date_naissance,
                'niveau_etude' => $request->niveau_etude,
                'dernier_diplome' => $request->dernier_diplome,
                'experience' => $request->experience,
            ]);
        }

        // update directeur
        $directeur = $formation->directeur;
        if ($directeur) {
            $directeur->update([
                'nom_prenom_d' => $request->nom_prenom_d,
                'num_cin' => $request->num_cin,
                'date_delivrance' => $request->date_delivrance,
                'lieu_delivrance' => $request->lieu_delivrance,
                'niveau_etude' => $request->niveau_etude,
                'dernier_diplome_obtenu' => $request->dernier_diplome_obtenu,
            ]);
        }

        // update formation
        $formation->update([
            'id_formulaire'  => $request->id_formulaire,
            'id_statut'      => $request->id_statut ?? 2,
            'type_espace_s_id' => $request->type_espace_s_id,
            'nbr_chambre'    => $request->nbr_chambre,
            'nbr_stade'      => $request->nbr_stade,
            'nbr_stages_sportifs' => $request->nbr_stages_sportifs,
            'nbr_salles'     => $request->nbr_salles,
            'nbr_vestiaire'  => $request->nbr_vestiaire,
            'nbr_salle_renforcement_musculaire' => $request->nbr_salle_renforcement_musculaire,
            'capacite_accueil_foyer' => $request->capacite_accueil_foyer,
            'capacite_accueil_stade' => $request->capacite_accueil_stade,
            'heberg_rest'    => $request->heberg_rest,
            'stage_activ'    => $request->stage_activ,
            'espace_exercice'=> $request->espace_exercice,
            'activite_culturel' => $request->activite_culturel,
            'manifestation_sportif' => $request->manifestation_sportif,
            'autres'         => $request->autres,
            'autres_services'=> $request->autres_services,
            'nom_projet'     => $request->nom_projet,
            'nature_projet_id' => $request->nature_projet_id,
            'nbr_emplois'    => $request->nbr_emplois,
            'remarques'      => $request->remarques,
            'commentaire_motif' => $request->commentaire_motif,
			'niveau_etude_user'  => $request->niveau_etude_user,
				'dernier_diplome_user' => $request->dernier_diplome_user,
				'experience_user'    => $request->experience_user,
				'id_user'            => $utilisateur->id, 
        ]);

        // replace investissements if provided
        if ($request->has('investissements')) {
            $formation->investissements()->delete();
            foreach ($request->investissements as $inv) {
                Investissement::create([
                    'user_id' => $utilisateur->id ?? null,
                    'secteur_invest_id' => $inv['secteur_invest_id'],
                    'montant_inv' => $inv['montant_inv'],
                    'source' => $inv['id_source_financement'] ?? null,
                    'remarques' => $inv['remarques'] ?? null,
                    'id_inv_sport' => $formation->id_inv_sport,
                ]);
            }
        }

        DB::commit();

    } catch (\Exception $e) {
        DB::rollBack();
        \Log::error('Formation update error: ' . $e->getMessage(), [
            'trace' => $e->getTraceAsString(),
            'id' => $id,
            'request' => $request->all()
        ]);
        return back()->withErrors(['error' => "خطأ أثناء التحديث : " . $e->getMessage()])->withInput();
    }

    // -------------------------
    // Post-commit: mail + DB notification (best-effort)
    // -------------------------
    try {
        $user = $utilisateur; // alias

        $mailTypeMap = [1 => 'accepte', 3 => 'refuse', 4 => 'incomplet', 5 => 'deferre'];
        $notifyTypeMap = [1 => 'accepted', 3 => 'rejected', 4 => 'incomplete', 5 => 'deferred'];

        $mailType = $mailTypeMap[$newStatus] ?? 'status_changed';
        $notifyType = $notifyTypeMap[$newStatus] ?? 'status_changed';

        $motif = $commentRefus
               ?? $commentStatus
               ?? $commentAccept
               ?? $commentAvis
               ?? $commentGeneric
               ?? $comment
               ?? null;
        $motif = is_string($motif) ? trim($motif) : null;

        $translationParams = [];
        if ($notifyType === 'rejected') {
            $translationParams['reason'] = $motif ?? '';
        } elseif ($notifyType === 'incomplete') {
            $translationParams['missing'] = $motif ?? '';
        } elseif ($notifyType === 'deferred') {
            $translationParams['note'] = $motif ?? '';
        } elseif ($notifyType === 'accepted') {
            $translationParams['reference'] = $formation->id_inv_sport;
        }

        if ($user && !empty($user->email)) {
            try {
                \Mail::to($user->email)->send(
                    new \App\Mail\FormationStatutMail($mailType, $user, $motif)
                );
                \Log::info("Formation status mail sent", ['formation_id' => $formation->id_inv_sport, 'to' => $user->email, 'type' => $mailType]);
            } catch (\Throwable $mailEx) {
                \Log::error("Formation mail send failed: " . $mailEx->getMessage(), ['formation_id' => $formation->id_inv_sport]);
            }

            try {
                $user->notify(new \App\Notifications\DocumentStatusNotification(
                    $notifyType,
                    $translationParams,
                    $formation->id_inv_sport
                ));
            } catch (\Throwable $notifEx) {
                \Log::error("Formation DB notification failed: " . $notifEx->getMessage(), ['formation_id' => $formation->id_inv_sport]);
            }
        } else {
            \Log::warning("Formation update: no user/email to notify for formation id {$formation->id_inv_sport}");
        }

    } catch (\Throwable $ex) {
        \Log::error("Post-commit notification error (formation update): " . $ex->getMessage(), ['formation_id' => $formation->id_inv_sport ?? null]);
    }

    return redirect()->route('admin.formation.index')
                ->with('success', 'تمّ تعديل الإستثمار الرياضي بنجاح');
}


    public function show($id)
    {
        $formation = InvestissementSport::with(['investissements', 'directeur', 'investissements.utilisateur'])->findOrFail($id);

        $formulaire = TypeFormulaire::find(5);
        $types_espace_es = TypeEspaceS::all();
        $types_espace = TypeEspaceInstitution::all();
        $nature_projet = NatureProjet::all();
        $secteurs = SecteurFinancement::all();
        $service_inst = ServiceInstitution::all();
        $source_fin = SourceFinancement::all();
        $statuts = \App\Models\TpStatut::all(); 
        return view('backoffice.investissement.gestion_formation_stage.show', compact(
            'formation','formulaire','types_espace_es','types_espace',
            'service_inst','secteurs','nature_projet','source_fin','statuts'
        ));
    }

    public function destroy($id)
    {
        DB::beginTransaction();
        try {
            $formation = InvestissementSport::findOrFail($id);
            $formation->investissements()->delete();
            $formation->delete();

            DB::commit();
            return redirect()->route('admin.formation.index')
                ->with('success', 'تمّ حذف الإستثمار الرياضي بنجاح');
        } catch (\Exception $e) {
            DB::rollBack();
            return back()->withErrors(['error' => " خطأ أثناء الحذف : " . $e->getMessage()]);
        }
    }
public function toggleStatut(Request $request, $id)
{
    $request->validate([
        'id_statut' => 'required|integer|in:1,2,3,4,5',
        'commentaire_motif' => 'nullable|string',
        'commentaire_refus' => 'nullable|string',
        'commentaire_status' => 'nullable|string',
        'commentaire_acceptation' => 'nullable|string',
        'commentaire_avis' => 'nullable|string',
    ]);

    DB::beginTransaction();

    try {
        $formation = InvestissementSport::with('investissements.utilisateur')->findOrFail($id);

        $oldStatus = (int) ($formation->id_statut ?? 0);
        $newStatus = (int) $request->input('id_statut');

        // no-op guard
        if ($oldStatus === $newStatus) {
            DB::rollBack();
            return redirect()->back()->with('info', 'لا تغيير في الوضعية.');
        }

        // build comment (request priority)
        $comment = null;
        if ($request->filled('commentaire_refus')) {
            $comment = trim($request->input('commentaire_refus'));
        } elseif ($request->filled('commentaire_status')) {
            $comment = trim($request->input('commentaire_status'));
        } elseif ($request->filled('commentaire_motif')) {
            $comment = trim($request->input('commentaire_motif'));
        }

        // fallback to acceptation / avis if still empty
        if (empty($comment)) {
            if ($request->filled('commentaire_acceptation')) {
                $comment = trim($request->input('commentaire_acceptation'));
            } elseif ($request->filled('commentaire_avis')) {
                $comment = trim($request->input('commentaire_avis'));
            }
        }
        if ($comment === '') $comment = null;

        // Apply new status and store comment in model
        $formation->id_statut = $newStatus;
        if ($newStatus === 3) {
            // refusal: keep the explicit refusal field if present, otherwise fallback
            $formation->commentaire_motif = $request->input('commentaire_motif')
                ?? $request->input('commentaire_refus')
                ?? $comment;
        } else {
            // for other statuses keep existing champ or store the unified comment
            $formation->commentaire_motif = $formation->commentaire_motif ?: $comment;
        }

        $formation->save();

        // create history
        $history = ImmobilierStatutHistory::create([
            'inv_sport_id'   => $formation->id_inv_sport,
            'from_statut_id' => $oldStatus ?: null,
            'to_statut_id'   => $newStatus ?: null,
            'changed_by'     => Auth::id() ?? null,
            'commentaire'    => $comment,
        ]);

        DB::commit();
    } catch (\Exception $e) {
        DB::rollBack();
        \Log::error('Erreur toggleStatut InvestissementSport: ' . $e->getMessage(), [
            'id' => $id, 'request' => $request->all()
        ]);
        return back()->withErrors(['error' => 'حدث خطأ أثناء تغيير الحالة: ' . $e->getMessage()]);
    }

    // -------------------------
    // Post-commit: mail + DB notification (best-effort)
    // -------------------------
    try {
        // refresh to ensure relations exist and are fresh
        $formation->refresh();
        $user = $formation->investissements->first()?->utilisateur ?? null;

        // map numeric->mail & notify types
        $mailTypeMap = [1 => 'accepte', 3 => 'refuse', 4 => 'incomplet', 5 => 'deferre'];
        $notifyTypeMap = [1 => 'accepted', 3 => 'rejected', 4 => 'incomplete', 5 => 'deferred'];

        $mailType = $mailTypeMap[$newStatus] ?? 'status_changed';
        $notifyType = $notifyTypeMap[$newStatus] ?? 'status_changed';

        // motif: prefer explicit request fields, then saved history.commentaire, then formation.commentaire_motif
        $motif = $request->input('commentaire_motif')
              ?? $request->input('commentaire_refus')
              ?? $request->input('commentaire_status')
              ?? $request->input('commentaire_acceptation')
              ?? $request->input('commentaire_avis');

        $motif = $motif ?: ($history->commentaire ?? $formation->commentaire_motif ?? null);
        $motif = is_string($motif) ? trim($motif) : null;

        // translation params for DB notification
        $translationParams = [];
        if ($notifyType === 'rejected') {
            $translationParams['reason'] = $motif ?? '';
        } elseif ($notifyType === 'incomplete') {
            $translationParams['missing'] = $motif ?? '';
        } elseif ($notifyType === 'deferred') {
            $translationParams['note'] = $motif ?? '';
        } elseif ($notifyType === 'accepted') {
            $translationParams['reference'] = $formation->id_inv_sport;
        }

        if ($user && !empty($user->email)) {
            // send mail for all supported types (best-effort)
            try {
                Mail::to($user->email)->send(new \App\Mail\FormationStatutMail($mailType, $user, $motif));
                \Log::info("toggleStatut: mail sent", ['formation' => $formation->id_inv_sport, 'to' => $user->email, 'type' => $mailType]);
            } catch (\Throwable $mailEx) {
                \Log::error("toggleStatut: mail failed for formation {$formation->id_inv_sport}: " . $mailEx->getMessage());
            }

            // store DB notification
            try {
                $user->notify(new \App\Notifications\DocumentStatusNotification(
                    $notifyType,
                    $translationParams,
                    $formation->id_inv_sport
                ));
                \Log::info("toggleStatut: DB notification created", ['formation' => $formation->id_inv_sport, 'user_id' => $user->id, 'type' => $notifyType]);
            } catch (\Throwable $notifEx) {
                \Log::error("toggleStatut: DB notification failed for formation {$formation->id_inv_sport}: " . $notifEx->getMessage());
            }
        } else {
            \Log::warning("toggleStatut: no user/email for formation id {$formation->id_inv_sport}");
        }
    } catch (\Throwable $ex) {
        \Log::error("toggleStatut post-commit error: " . $ex->getMessage(), ['formation' => $formation->id_inv_sport ?? null]);
    }

    return redirect()->back()->with('success', 'تم تغيير حالة الطلب بنجاح');
}






}
