<?php

namespace App\Http\Controllers\Investissement;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\DebutActivite;
use App\Models\Immobilier;
use App\Models\Identite_personnel;
use App\Models\Utilisateur;
use Illuminate\Support\Facades\Storage;
use App\Mail\DebutActiviteStatutMail;
use Illuminate\Support\Facades\Mail;
use Carbon\Carbon;
use App\Notifications\DebutActiviteStatutNotification;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Mpdf\Mpdf;
use App\Models\ImmobilierStatutHistory;
use App\Models\TpStatut;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;

class DebutActiviteController extends Controller
{
    /*public function index(Request $request)
    {
        
$query = DebutActivite::with('immobilier.utilisateur','activiteJeuneEnfant.utilisateur')->orderByDesc('created_at');   
  if ($request->filled('search_option') && $request->search_option == 'date' && $request->filled('date')) {    
  $query->whereDate('date_debut_activite', $request->date);    }    
  if ($request->filled('search_option') && $request->search_option == 'type_identite' && $request->filled('type_identite')) {  
  $type = $request->type_identite;        if ($type == 1 && $request->filled('cin')) {          
  $query->whereHas('immobilier.utilisateur', fn($q) => $q->where('cin', $request->cin));        }    
  if ($type == 2 && $request->filled('passport')) {          
  $query->whereHas('immobilier.utilisateur', fn($q) => $q->where('passport', $request->passport));    
  }        if ($type == 3 && $request->filled('num_fiscal')) {         
  $query->whereHas('immobilier.utilisateur', fn($q) => $q->where('num_fiscal', $request->num_fiscal));    
  }   
  }    $debutActivites = $query->paginate(10)->withQueryString();   
  $typesIdentite = Identite_personnel::all();
        return view('backoffice.investissement.gestion_salle_sport.debut_activite.index', compact('debutActivites', 'typesIdentite'));
    }*/
	
	/*public function index(Request $request)
{
    $query = DebutActivite::with([
            'immobilier.utilisateur',
            'activiteJeuneEnfant.utilisateur',
            'insts.utilisateur',
            'projet_debut.utilisateur',
            'sport.utilisateur'
        ])
        ->orderByDesc('created_at');
    
    // Recherche par date
    if ($request->filled('search_option') && $request->search_option == 'date' && $request->filled('date')) {
        $query->whereDate('date_debut_activite', $request->date);
    }
    
    // Recherche par type d'identité - Recherche dans TOUTES les relations
    if ($request->filled('search_option') && $request->search_option == 'type_identite' && $request->filled('type_identite')) {
        $type = $request->type_identite;
        
        $query->where(function($q) use ($type, $request) {
            // Recherche dans immobilier.utilisateur
            if ($type == 1 && $request->filled('cin')) {
                $q->whereHas('immobilier.utilisateur', fn($sub) => $sub->where('cin', $request->cin));
            }
            if ($type == 2 && $request->filled('passport')) {
                $q->whereHas('immobilier.utilisateur', fn($sub) => $sub->where('passport', $request->passport));
            }
            if ($type == 3 && $request->filled('num_fiscal')) {
                $q->whereHas('immobilier.utilisateur', fn($sub) => $sub->where('num_fiscal', $request->num_fiscal));
            }
            
            // Recherche dans activiteJeuneEnfant.utilisateur
            if ($type == 1 && $request->filled('cin')) {
                $q->orWhereHas('activiteJeuneEnfant.utilisateur', fn($sub) => $sub->where('cin', $request->cin));
            }
            if ($type == 2 && $request->filled('passport')) {
                $q->orWhereHas('activiteJeuneEnfant.utilisateur', fn($sub) => $sub->where('passport', $request->passport));
            }
            if ($type == 3 && $request->filled('num_fiscal')) {
                $q->orWhereHas('activiteJeuneEnfant.utilisateur', fn($sub) => $sub->where('num_fiscal', $request->num_fiscal));
            }
            
            // Recherche dans insts.utilisateur (si applicable)
            if ($type == 1 && $request->filled('cin')) {
                $q->orWhereHas('insts.utilisateur', fn($sub) => $sub->where('cin', $request->cin));
            }
            // ... etc pour les autres relations
        });
    }
    
    $debutActivites = $query->paginate(10)->withQueryString();
    $typesIdentite = Identite_personnel::all();
    
    return view('backoffice.investissement.gestion_salle_sport.debut_activite.index', compact('debutActivites', 'typesIdentite'));
}

    public function create(Request $request)
    {
        $immobilier_id = $request->query('immobilier_id', null);
        return view('backoffice.investissement.gestion_salle_sport.debut_activite.create', compact('immobilier_id'));
    }

    public function exportExcel(Request $request)
{
    $query = DebutActivite::with('immobilier.utilisateur', 'statut')->orderByDesc('created_at');

    // Filtrer comme dans index
    if ($request->filled('search_option') && $request->search_option == 'date' && $request->filled('date')) {
        $query->whereDate('date_debut_activite', $request->date);
    }

    if ($request->filled('search_option') && $request->search_option == 'type_identite' && $request->filled('type_identite')) {
        $type = $request->type_identite;
        if ($type == 1 && $request->filled('cin')) {
            $query->whereHas('immobilier.utilisateur', fn($q) => $q->where('cin', $request->cin));
        }
        if ($type == 2 && $request->filled('passport')) {
            $query->whereHas('immobilier.utilisateur', fn($q) => $q->where('passport', $request->passport));
        }
        if ($type == 3 && $request->filled('num_fiscal')) {
            $query->whereHas('immobilier.utilisateur', fn($q) => $q->where('num_fiscal', $request->num_fiscal));
        }
    }

    $debutActivites = $query->get();

    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->setRightToLeft(true);

    // Header
    $sheet->fromArray([
        ['المعرف', 'اسم المستخدم', 'تاريخ بداية النشاط', 'الحالة']
    ], null, 'A1');
    $sheet->getStyle('A1:D1')->getFont()->setBold(true);

    // Data
    $row = 2;
    foreach ($debutActivites as $activite) {
        $sheet->setCellValue('A'.$row, $activite->id_debut);
        $sheet->setCellValue('B'.$row, $activite->immobilier && $activite->immobilier->utilisateur 
            ? $activite->immobilier->utilisateur->nom_prenom : '---');
        $sheet->setCellValue('C'.$row, $activite->date_debut_activite ? $activite->date_debut_activite->format('Y-m-d') : '---');
        $sheet->setCellValue('D'.$row, $activite->statut->statut_ar ?? 'في الانتظار');
        $row++;
    }

    foreach (range('A', 'D') as $col) {
        $sheet->getColumnDimension($col)->setAutoSize(true);
    }

    $writer = new Xlsx($spreadsheet);
    $fileName = 'debut_activite.xlsx';

    return response()->streamDownload(function () use ($writer) {
        $writer->save('php://output');
    }, $fileName);
}*/

public function index(Request $request)
{
    $query = DebutActivite::with([
        'immobilier.utilisateur',
        'activiteJeuneEnfant.utilisateur',
        'insts.utilisateur',
        'projet_debut.utilisateur',
        'sport.utilisateur',
        'statut' // Toujours utile
    ])
    ->orderByDesc('created_at');
    
    // Recherche par date
    if ($request->filled('search_option') && $request->search_option == 'date' && $request->filled('date')) {
        $query->whereDate('date_debut_activite', $request->date);
    }
    
    // Recherche par type d'identité
    if ($request->filled('search_option') && $request->search_option == 'type_identite' && $request->filled('type_identite')) {
        $type = $request->type_identite;
        
        $query->where(function($q) use ($type, $request) {
            // Recherche dans toutes les relations
            
            // Recherche dans projet_debut.utilisateur (AJOUTEZ CE BLOC)
            if ($type == 1 && $request->filled('cin')) {
                $q->whereHas('projet_debut.utilisateur', fn($sub) => $sub->where('cin', $request->cin));
            }
            if ($type == 2 && $request->filled('passport')) {
                $q->whereHas('projet_debut.utilisateur', fn($sub) => $sub->where('passport', $request->passport));
            }
            if ($type == 3 && $request->filled('num_fiscal')) {
                $q->whereHas('projet_debut.utilisateur', fn($sub) => $sub->where('num_fiscal', $request->num_fiscal));
            }
            
            // Recherche dans immobilier.utilisateur
            if ($type == 1 && $request->filled('cin')) {
                $q->orWhereHas('immobilier.utilisateur', fn($sub) => $sub->where('cin', $request->cin));
            }
            if ($type == 2 && $request->filled('passport')) {
                $q->orWhereHas('immobilier.utilisateur', fn($sub) => $sub->where('passport', $request->passport));
            }
            if ($type == 3 && $request->filled('num_fiscal')) {
                $q->orWhereHas('immobilier.utilisateur', fn($sub) => $sub->where('num_fiscal', $request->num_fiscal));
            }
            
            // Recherche dans activiteJeuneEnfant.utilisateur
            if ($type == 1 && $request->filled('cin')) {
                $q->orWhereHas('activiteJeuneEnfant.utilisateur', fn($sub) => $sub->where('cin', $request->cin));
            }
            if ($type == 2 && $request->filled('passport')) {
                $q->orWhereHas('activiteJeuneEnfant.utilisateur', fn($sub) => $sub->where('passport', $request->passport));
            }
            if ($type == 3 && $request->filled('num_fiscal')) {
                $q->orWhereHas('activiteJeuneEnfant.utilisateur', fn($sub) => $sub->where('num_fiscal', $request->num_fiscal));
            }
            
            // Recherche dans insts.utilisateur
            if ($type == 1 && $request->filled('cin')) {
                $q->orWhereHas('insts.utilisateur', fn($sub) => $sub->where('cin', $request->cin));
            }
            if ($type == 2 && $request->filled('passport')) {
                $q->orWhereHas('insts.utilisateur', fn($sub) => $sub->where('passport', $request->passport));
            }
            if ($type == 3 && $request->filled('num_fiscal')) {
                $q->orWhereHas('insts.utilisateur', fn($sub) => $sub->where('num_fiscal', $request->num_fiscal));
            }
            
            // Recherche dans sport.utilisateur
            if ($type == 1 && $request->filled('cin')) {
                $q->orWhereHas('sport.utilisateur', fn($sub) => $sub->where('cin', $request->cin));
            }
            if ($type == 2 && $request->filled('passport')) {
                $q->orWhereHas('sport.utilisateur', fn($sub) => $sub->where('passport', $request->passport));
            }
            if ($type == 3 && $request->filled('num_fiscal')) {
                $q->orWhereHas('sport.utilisateur', fn($sub) => $sub->where('num_fiscal', $request->num_fiscal));
            }
        });
    }
    
    $debutActivites = $query->paginate(10)->withQueryString();
    $typesIdentite = Identite_personnel::all();
    
    return view('backoffice.investissement.gestion_salle_sport.debut_activite.index', compact('debutActivites', 'typesIdentite'));
}

public function exportPdf(Request $request)
{
    $query = DebutActivite::with('immobilier.utilisateur', 'statut')->orderByDesc('created_at');

    // Filtrage comme dans index
    if ($request->filled('search_option') && $request->search_option == 'date' && $request->filled('date')) {
        $query->whereDate('date_debut_activite', $request->date);
    }

    if ($request->filled('search_option') && $request->search_option == 'type_identite' && $request->filled('type_identite')) {
        $type = $request->type_identite;
        if ($type == 1 && $request->filled('cin')) {
            $query->whereHas('immobilier.utilisateur', fn($q) => $q->where('cin', $request->cin));
        }
        if ($type == 2 && $request->filled('passport')) {
            $query->whereHas('immobilier.utilisateur', fn($q) => $q->where('passport', $request->passport));
        }
        if ($type == 3 && $request->filled('num_fiscal')) {
            $query->whereHas('immobilier.utilisateur', fn($q) => $q->where('num_fiscal', $request->num_fiscal));
        }
    }

    $debutActivites = $query->get();

    $html = view('backoffice.investissement.gestion_salle_sport.exports.debut_activite_pdf', compact('debutActivites'))->render();

    $mpdf = new Mpdf([
        'mode' => 'utf-8',
        'format' => 'A4',
        'default_font' => 'dejavusans',
        'directionality' => 'rtl',
    ]);

    $mpdf->WriteHTML($html);

    return response($mpdf->Output('debut_activite.pdf', 'S'))
        ->header('Content-Type', 'application/pdf');
}

    public function store(Request $request)
    {
        $validated = $request->validate([
            'immobilier_id' => 'required|exists:immobilier,id_imm',
'date_debut_activite' => 'required|date',            
'preuve_propriete_location' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'plan_architectural' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'declaration_investissement' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'identification' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'extrait_registre_national_entreprise' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'certificat_prevention' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'contrat_assurance' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'approbation_autorite_minicipale' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
        ]);

        $uploads = [];
        foreach ([
            'preuve_propriete_location',
            'plan_architectural',
            'declaration_investissement',
            'identification',
            'extrait_registre_national_entreprise',
            'certificat_prevention',
            'contrat_assurance',
            'approbation_autorite_minicipale',
        ] as $fileField) {

        if ($request->hasFile($fileField)) {
            $file = $request->file($fileField);
            $originalName = $file->getClientOriginalName();
            $filename = pathinfo($originalName, PATHINFO_FILENAME);
            $extension = $file->getClientOriginalExtension();

            // Générer un nom unique en ajoutant un timestamp
            $uniqueName = $filename. '.' . $extension;

            // Stocker le fichier dans public/uploads/debut_activite
            $uploads[$fileField] = $file->storeAs('uploads/debut_activite', $uniqueName, 'public');
        }
    }

        DebutActivite::create([
            'immobilier_id' => $request->immobilier_id,
            'date_debut_activite' => $request->date_debut_activite,
            'preuve_propriete_location' => $uploads['preuve_propriete_location'] ?? null,
            'plan_architectural' => $uploads['plan_architectural'] ?? null,
            'declaration_investissement' => $uploads['declaration_investissement'] ?? null,
            'identification' => $uploads['identification'] ?? null,
            'extrait_registre_national_entreprise' => $uploads['extrait_registre_national_entreprise'] ?? null,
            'certificat_prevention' => $uploads['certificat_prevention'] ?? null,
            'contrat_assurance' => $uploads['contrat_assurance'] ?? null,
            'approbation_autorite_minicipale' => $uploads['approbation_autorite_minicipale'] ?? null,
            'etat_formulaire' => 'remplir',
            'id_type_formulaire' => 2,
            'id_statut' => 2,
        ]);

        return redirect()->route('admin.debut_activite.index')->with('success', 'تم تسجيل بداية النشاط بنجاح ');
    }

public function verifierIdentite(Request $request)
{
    $request->validate([
        'id_type_identite' => 'required|exists:tp_type_identite_pers,id_type',
        'identifiant' => 'required|string',
        'immobilier_id' => 'required|exists:immobilier,id_imm'
    ]);

    $idType = $request->id_type_identite;
    $identifiant = $request->identifiant;
    $immobilier_id = $request->immobilier_id;

    $immobilier = Immobilier::with('utilisateur','gouvernorat')->find($immobilier_id);
    if(!$immobilier) return response()->json(['success' => false]);

    $user = $immobilier->utilisateur;
    $match = false;

    if($idType == 1 && $user->cin == $identifiant) $match = true;
    if($idType == 2 && $user->passport == $identifiant) $match = true;
    if($idType == 3 && $user->num_fiscal == $identifiant) $match = true;

    if($match) {
        return response()->json([
            'success' => true,
            'user' => $user,
            'immobilier' => [
                'id_imm' => $immobilier->id_imm,
                'gouvernorat_nom_ar' => $immobilier->gouvernorat->nom_ar ?? null
            ]
        ]);
    }

    return response()->json(['success' => false]);
}

/*public function edit($id)
{
    $debutActivite = DebutActivite::with([
        'immobilier.utilisateur',
        'immobilier.gouvernorat',
        'statutHistories.fromStatut',
        'statutHistories.toStatut',
        'statutHistories.changer',
    ])->findOrFail($id);

    $immobilier_id = $debutActivite->immobilier_id;
	$id_activite_jeune_enfant = $debutActivite->id_activite_jeune_enfant;
    $statuts = TpStatut::orderBy('id_statut')->get();

    return view('backoffice.investissement.gestion_salle_sport.debut_activite.edit', compact(
        'debutActivite', 'immobilier_id', 'statuts','id_activite_jeune_enfant'
    ));
}
*/

public function edit($id)
{
    $debutActivite = DebutActivite::with([
        'immobilier.utilisateur',
        'immobilier.gouvernorat',
        'activiteJeuneEnfant.utilisateur',
		'activiteJeuneEnfant.gouvernorat',
        'insts.utilisateur',
		'insts.gouvernorat',
        'projet_debut.utilisateur',
		'projet_debut.gouvernorat',
        'sport.utilisateur',
		'sport.gouvernorat',
        'statutHistories.fromStatut',
        'statutHistories.toStatut',
        'statutHistories.changer',
    ])->findOrFail($id);

    // Récupérez l'utilisateur via l'accesseur
    $utilisateur = $debutActivite->utilisateur;
    
    // Récupérez aussi le gouvernorat selon la relation
    $gouvernorat = null;
    if ($debutActivite->immobilier && $debutActivite->immobilier->gouvernorat) {
        $gouvernorat = $debutActivite->immobilier->gouvernorat;
    } elseif ($debutActivite->projet_debut && $debutActivite->projet_debut->gouvernorat) {
        $gouvernorat = $debutActivite->projet_debut->gouvernorat;
    }
    // Ajoutez d'autres conditions pour les autres relations si elles ont un gouvernorat

    $statuts = TpStatut::orderBy('id_statut')->get();

    return view('backoffice.investissement.gestion_salle_sport.debut_activite.edit', compact(
        'debutActivite', 'utilisateur', 'gouvernorat', 'statuts'
    ));
}


public function update(Request $request, $id)
{
    $debutActivite = DebutActivite::findOrFail($id);

    $validated = $request->validate([
        'immobilier_id' => 'nullable|exists:immobilier,id_imm',
		'id_activite_jeune_enfant' => 'nullable|exists:activites_jeune_enfant,id_jeune_enfant',
        'id_insts' => 'nullable|exists:institution_prive_jeunesse,id_inst',
        'id_projet_debut' => 'nullable|exists:projet_divertissement_jeune_enfant,id_projet',
        'id_inv_sport_debut' => 'nullable|exists:investissement_sport,id_inv_sport',
		
        'date_debut_activite' => 'required|date',
        'id_statut' => 'nullable|integer|in:1,2,3,4,5',
        'commentaire_motif' => 'nullable|string|max:255',
        'preuve_propriete_location' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'plan_architectural' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'declaration_investissement' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'identification' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'extrait_registre_national_entreprise' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'certificat_prevention' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'contrat_assurance' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'approbation_autorite_minicipale' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
    ]);

    $oldStatut = (int) $debutActivite->id_statut;
    $newStatut = isset($request->id_statut) ? (int) $request->id_statut : $oldStatut;

    // unify comment logic (accept various incoming comment fields)
    $comment = null;
    if ($request->filled('commentaire_refus')) {
        $comment = trim($request->input('commentaire_refus'));
    } elseif ($request->filled('commentaire_status')) {
        $comment = trim($request->input('commentaire_status'));
    } elseif ($request->filled('commentaire_motif')) {
        $comment = trim($request->input('commentaire_motif'));
    } elseif ($request->filled('commentaire_acceptation')) {
        $comment = trim($request->input('commentaire_acceptation'));
    } elseif ($request->filled('commentaire_avis')) {
        $comment = trim($request->input('commentaire_avis'));
    }
    if ($comment === '') $comment = null;
	
	 $fileFields = [
        'preuve_propriete_location',
        'plan_architectural',
        'declaration_investissement',
        'identification',
        'extrait_registre_national_entreprise',
        'certificat_prevention',
        'contrat_assurance',
        'approbation_autorite_minicipale',
    ];

    $uploadDir = '/home/preprov/www/mjs/shared_uploads/images';

    if (!is_dir($uploadDir) || !is_writable($uploadDir)) {
        abort(500, 'Dossier upload non accessible');
    }

    foreach ($fileFields as $field) {
        if ($request->hasFile($field)) {

            $file = $request->file($field);

            // 🧹 supprimer ancien fichier
            if (!empty($debutActivite->$field) && file_exists($debutActivite->$field)) {
                @unlink($debutActivite->$field);
            }

            // 🔐 nom sécurisé
            $original = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $ext = $file->getClientOriginalExtension();
            $safe = Str::slug(mb_substr($original, 0, 40)) ?: 'document';

            $filename = $safe . '-' . time() . '-' . Str::random(6) . '.' . $ext;
            $targetPath = $uploadDir . DIRECTORY_SEPARATOR . $filename;

            // 🚀 upload réel
            $file->move($uploadDir, $filename);

            $realPath = realpath($targetPath);
            if ($realPath === false) {
                abort(500, 'Erreur lors de la sauvegarde du fichier');
            }

            // 💾 stocker le PATH STRING en DB
            $debutActivite->$field = $realPath;
        }
    }

    $updateData = [
        'immobilier_id' => $request->immobilier_id,
		'id_activite_jeune_enfant' => $request->id_activite_jeune_enfant,
        'date_debut_activite' => $request->date_debut_activite,
        'id_statut' => $request->id_statut ?? $debutActivite->id_statut,
        'commentaire_motif' => $comment ?? $debutActivite->commentaire_motif,
        'etat_formulaire' => in_array($newStatut, [1, 3]) ? 'reponse' : $debutActivite->etat_formulaire,
    ];
    $updateData = array_merge($updateData, $fileFields);

    $debutActivite->update($updateData);

    // create history if changed
    if ($oldStatut !== $newStatut) {
        $history = ImmobilierStatutHistory::create([
            'immobilier_id'     => $debutActivite->immobilier_id,
            'debut_activite_id' => $debutActivite->id_debut,
            'from_statut_id'    => $oldStatut ?: null,
            'to_statut_id'      => $newStatut ?: null,
            'changed_by'        => Auth::id() ?? null,
            'commentaire'       => $comment,
        ]);
    } else {
        $history = null;
    }

    // Notify & Mail if statut changed
    $user = $debutActivite->immobilier->utilisateur ?? null;
    if ($oldStatut !== $newStatut && $user) {
        $statusMap = [1 => 'accepted', 3 => 'rejected', 4 => 'incomplete', 5 => 'deferred'];
        $normType = $statusMap[$newStatut] ?? 'status_changed';

        $translationParams = ['reference' => $debutActivite->id_debut];
        if ($normType === 'accepted') {
            $translationParams['date'] = Carbon::parse($debutActivite->date_debut_activite ?? now())->toDateString();
        } elseif ($normType === 'rejected') {
            $translationParams['reason'] = $history->commentaire ?? $comment ?? ($request->commentaire_motif ?? '');
        } elseif ($normType === 'incomplete') {
            $translationParams['missing'] = $request->input('commentaire_acceptation') ?? $history->commentaire ?? $comment ?? '';
        } elseif ($normType === 'deferred') {
            $translationParams['note'] = $request->input('commentaire_avis') ?? $history->commentaire ?? $comment ?? '';
        }

        // send mail for all types 1,3,4,5 — with comment if exists
        try {
            $mailComment = $history->commentaire ?? $comment ?? null;
            $mailType = ($newStatut === 1) ? 'accepte' : (($newStatut === 3) ? 'refuse' : (($newStatut === 4) ? 'incomplet' : 'deferre'));
            // if accepted you may want to pass date; else pass commentary
            $dateParam = ($newStatut === 1) ? Carbon::parse($debutActivite->date_debut_activite ?? now())->addDays(0) : null;

            Mail::to($user->email)->send(
                new \App\Mail\DebutActiviteStatutMail($mailType, $user, $mailComment, $dateParam)
            );
        } catch (\Throwable $e) {
            \Log::error("Mail send error DebutActivite update: ".$e->getMessage(), ['debut_activite_id'=>$debutActivite->id_debut]);
        }

        // DB notification
        try {
            $user->notify(new \App\Notifications\DebutActiviteStatutNotification($normType, $translationParams));
        } catch (\Throwable $e) {
            \Log::error("Notification error DebutActivite update: ".$e->getMessage(), ['debut_activite_id'=>$debutActivite->id_debut]);
        }
    }

    return redirect()->route('admin.debut_activite.index')
                     ->with('success', 'تم تحديث بيانات بداية النشاط بنجاح');
}
public function download($id, $field)
{
    $debutActivite = DebutActivite::findOrFail($id);

    $allowed = [
        'preuve_propriete_location',
        'plan_architectural',
        'declaration_investissement',
        'identification',
        'extrait_registre_national_entreprise',
        'certificat_prevention',
        'contrat_assurance',
        'approbation_autorite_minicipale',
    ];

    if (!in_array($field, $allowed, true)) {
        abort(404);
    }

    $path = $debutActivite->$field;

    if (empty($path) || !file_exists($path)) {
        abort(404, 'Fichier introuvable');
    }

    return response()->file($path, [
        'Content-Type' => mime_content_type($path),
        'Content-Disposition' => 'inline; filename="' . basename($path) . '"',
        'Cache-Control' => 'no-store, no-cache, must-revalidate, max-age=0',
        'Pragma' => 'no-cache',
        'Expires' => '0',
    ]);
}

/*public function download($id, $field)
{
    $debutActivite = \App\Models\DebutActivite::findOrFail($id);
    $fileContent = $debutActivite->$field;

    if (!$fileContent) {
        abort(404);
    }

    // Détecter le type MIME du fichier
    $finfo = new \finfo(FILEINFO_MIME_TYPE);
    $mime = $finfo->buffer($fileContent);

    // Déterminer l'extension pour le nom du fichier
    $extension = '';
    switch ($mime) {
        case 'application/pdf':
            $extension = 'pdf';
            break;
        case 'image/jpeg':
            $extension = 'jpg';
            break;
        case 'image/png':
            $extension = 'png';
            break;
        default:
            $extension = 'bin';
            break;
    }

    return response($fileContent)
           ->header('Content-Type', $mime)
           ->header('Content-Disposition', 'inline; filename="'.$field.'.'.$extension.'"');
}*/



/*   
public function update(Request $request, $id)
{
    $debutActivite = DebutActivite::findOrFail($id);

    // Validation
    $validated = $request->validate([
        'immobilier_id' => 'required|exists:immobilier,id_imm',
        //'date_debut_activite' => 'required|date|after_or_equal:' . now()->addDays(15)->toDateString(),
        'date_debut_activite' => 'required|date',
        'id_statut' => 'nullable',
        'commentaire_motif' => 'nullable|string|max:255',
        'preuve_propriete_location' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'plan_architectural' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'declaration_investissement' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'identification' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'extrait_registre_national_entreprise' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'certificat_prevention' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'contrat_assurance' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'approbation_autorite_minicipale' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
    ]);
		$oldStatut = (int) $debutActivite->id_statut;
		$newStatut = isset($request->id_statut) ? (int) $request->id_statut : $oldStatut;
		$dateDebut = Carbon::now()->addDays(15);
        $comment = null;

			if ($request->filled('commentaire_refus')) {
				$comment = trim($request->input('commentaire_refus'));
			} elseif ($request->filled('commentaire_status')) {
				$comment = trim($request->input('commentaire_status'));
			} elseif ($request->filled('commentaire_motif')) {
				$comment = trim($request->input('commentaire_motif'));
			}
		 
			if ($comment === '') $comment = null;

    $uploads = [];
	foreach ([
		'preuve_propriete_location',
		'plan_architectural',
		'declaration_investissement',
		'identification',
		'extrait_registre_national_entreprise',
		'certificat_prevention',
		'contrat_assurance',
		'approbation_autorite_minicipale',
	] as $fileField) {
		if ($request->hasFile($fileField)) {
			$file = $request->file($fileField);
			$content = file_get_contents($file->getRealPath());
			$uploads[$fileField] = $content;
		}
	}


    // Préparer les données à mettre à jour
    $updateData = [
        'immobilier_id' => $request->immobilier_id,
        'date_debut_activite' => $request->date_debut_activite,
        'id_statut' => $request->id_statut ?? $debutActivite->id_statut, 
        'commentaire_motif' => $comment ?? $debutActivite->commentaire_motif,
        'etat_formulaire' => in_array($request->id_statut, [1, 3]) ? 'reponse' : $debutActivite->etat_formulaire,
    ];

    // Merge fichiers uploadés
    $updateData = array_merge($updateData, $uploads);

    // Mise à jour de l'enregistrement
    $debutActivite->update($updateData);
if ($oldStatut !== $newStatut) {
    ImmobilierStatutHistory::create([
        'immobilier_id'      => $debutActivite->immobilier_id,
        'debut_activite_id'  => $debutActivite->id_debut,
        'from_statut_id'     => $oldStatut ?: null,
        'to_statut_id'       => $newStatut ?: null,
        'changed_by'         => Auth::id() ?? null,
        'commentaire'        => $comment,
   
    ]);
}
   // NOTIFICATIONS: send translated DB notification for ALL status types
    $user = $debutActivite->immobilier->utilisateur;
    if ($oldStatut !== $newStatut && $user) {
        // map numeric -> normalized translation type
        $statusMap = [
            1 => 'accepted',
            3 => 'rejected',
            4 => 'incomplete',
            5 => 'deferred',
        ];
        $normType = $statusMap[$newStatut] ?? 'status_changed';

        // prepare params used by translation strings
        $translationParams = [];
        // accepted: include proposed start date if you want
        if ($normType === 'accepted') {
            // use the dateDebut logic you had earlier (if needed)
            $dateDebut = Carbon::parse($request->date_debut_activite ?? now())->toDateString();
            $translationParams['date'] = $dateDebut;
            $translationParams['reference'] = $debutActivite->id_debut;
        } elseif ($normType === 'rejected') {
            $translationParams['reason'] = $comment ?? ($request->commentaire_motif ?? '');
            $translationParams['reference'] = $debutActivite->id_debut;
        } elseif ($normType === 'incomplete') {
            $translationParams['missing'] = $request->input('commentaire_acceptation') ?? $comment ?? '';
            $translationParams['reference'] = $debutActivite->id_debut;
        } elseif ($normType === 'deferred') {
            $translationParams['note'] = $request->input('commentaire_avis') ?? $comment ?? '';
            $translationParams['reference'] = $debutActivite->id_debut;
        } else {
            $translationParams['reference'] = $debutActivite->id_debut;
        }

        // optionally keep the previous mail logic for accepted/rejected
        try {
          //  /*if ($newStatut == 3 && !empty($request->commentaire_motif)) {
          //      Mail::to($user->email)->send(
                    new DebutActiviteStatutMail('refuse', $user, null, $request->commentaire_motif)
          //      );
          //  } elseif ($newStatut == 1) {
            //    $dateDebut = Carbon::now()->addDays(15);
            //    Mail::to($user->email)->send(
            //        new DebutActiviteStatutMail('accepte', $user, $dateDebut)
            //    );
				
				
				 if ($newStatut == 3) {

        $commentaire = $request->commentaire_motif ?? null;

        Mail::to($user->email)->send(
            new DebutActiviteStatutMail(
                'refuse',
                $user,
                $commentaire
            )
        );

    } elseif ($newStatut == 1) {

        Mail::to($user->email)->send(
            new DebutActiviteStatutMail(
                'accepte',
                $user
            )
        );
            }
        } catch (\Exception $e) {
            \Log::error("Mail send error DebutActivite update: ".$e->getMessage());
        }

        // send the DB notification (translation-aware)
        $user->notify(new DebutActiviteStatutNotification($normType, $translationParams));
    }

    return redirect()->route('admin.debut_activite.index')
                     ->with('success', 'تم تحديث بيانات بداية النشاط بنجاح');
}
*/




public function toggleStatut(Request $request, $id)
{
    $request->validate([
        'id_statut' => 'required|integer|in:1,2,3,4,5',
        'commentaire_motif' => 'nullable|string',
        'commentaire_refus' => 'nullable|string',
        'commentaire_status' => 'nullable|string',
        'commentaire_acceptation' => 'nullable|string',
        'commentaire_avis' => 'nullable|string',
    ]);

    $debutActivite = DebutActivite::with('immobilier.utilisateur')->findOrFail($id);

    $old = (int) ($debutActivite->id_statut ?? 0);
    $new = (int) $request->input('id_statut');

    if ($old === $new) {
        return redirect()->back()->with('info', 'لا تغيير في الوضعية.');
    }

    // pick comment
    $comment = null;
    if ($request->filled('commentaire_refus')) {
        $comment = trim($request->input('commentaire_refus'));
    } elseif ($request->filled('commentaire_status')) {
        $comment = trim($request->input('commentaire_status'));
    } elseif ($request->filled('commentaire_motif')) {
        $comment = trim($request->input('commentaire_motif'));
    } elseif ($request->filled('commentaire_acceptation')) {
        $comment = trim($request->input('commentaire_acceptation'));
    } elseif ($request->filled('commentaire_avis')) {
        $comment = trim($request->input('commentaire_avis'));
    }
    if ($comment === '') $comment = null;

    // set etat_formulaire for terminal statuses
    if (in_array($new, [1, 3])) {
        $debutActivite->etat_formulaire = 'reponse';
    }

    // put unified comment in commentaire_motif (backward compat) and set statut
    $debutActivite->commentaire_motif = $comment ?: $debutActivite->commentaire_motif;
    $debutActivite->id_statut = $new;
    $debutActivite->save();

    // history
    $history = ImmobilierStatutHistory::create([
        'immobilier_id'      => $debutActivite->immobilier_id,
        'debut_activite_id'  => $debutActivite->id_debut,
        'from_statut_id'     => $old ?: null,
        'to_statut_id'       => $new ?: null,
        'changed_by'         => Auth::id() ?? null,
        'commentaire'        => $comment,
    ]);

    // notifications & mail
    $user = $debutActivite->immobilier->utilisateur ?? null;
    if ($user) {
        $statusMap = [1 => 'accepted', 3 => 'rejected', 4 => 'incomplete', 5 => 'deferred'];
        $normType = $statusMap[$new] ?? 'status_changed';

        $translationParams = ['reference' => $debutActivite->id_debut];
        if ($normType === 'accepted') {
            $translationParams['date'] = Carbon::parse($debutActivite->date_debut_activite ?? now())->toDateString();
        } elseif ($normType === 'rejected') {
            $translationParams['reason'] = $history->commentaire ?? $comment ?? '';
        } elseif ($normType === 'incomplete') {
            $translationParams['missing'] = $request->input('commentaire_acceptation') ?? $history->commentaire ?? $comment ?? '';
        } elseif ($normType === 'deferred') {
            $translationParams['note'] = $request->input('commentaire_avis') ?? $history->commentaire ?? $comment ?? '';
        }

        // send email for all relevant statuses (accepte, refuse, incomplet, deferre)
        try {
            $mailComment = $history->commentaire ?? $comment ?? null;
            $mailType = ($new === 1) ? 'accepte' : (($new === 3) ? 'refuse' : (($new === 4) ? 'incomplet' : 'deferre'));
            $dateParam = ($new === 1) ? Carbon::parse($debutActivite->date_debut_activite ?? now()) : null;

            Mail::to($user->email)->send(
                new \App\Mail\DebutActiviteStatutMail($mailType, $user, $mailComment, $dateParam)
            );
        } catch (\Throwable $e) {
            \Log::error("Mail send error DebutActivite toggleStatut: ".$e->getMessage(), ['debut_activite_id' => $debutActivite->id_debut]);
        }

        // DB notification
        try {
            $user->notify(new \App\Notifications\DebutActiviteStatutNotification($normType, $translationParams));
        } catch (\Throwable $e) {
            \Log::error("Notification error DebutActivite toggleStatut: ".$e->getMessage(), ['debut_activite_id' => $debutActivite->id_debut]);
        }
    } else {
        \Log::warning("Aucun utilisateur trouvé pour DebutActivite ID {$id}");
    }

    return redirect()->back()->with('success', 'تم تغيير حالة الطلب بنجاح');
}



/*
public function toggleStatut(Request $request, $id)
{
    $debutActivite = DebutActivite::with('immobilier.utilisateur')->findOrFail($id);

    $old = (int) ($debutActivite->id_statut ?? 0);
    $new = (int) $request->id_statut;

    // quickly set etat_formulaire for terminal statuses
    if (in_array($new, [1, 3])) {
        $debutActivite->etat_formulaire = 'reponse';
    }

    // set comment if present
    if ($new == 3 && $request->filled('commentaire_motif')) {
        $debutActivite->commentaire_motif = $request->commentaire_motif;
    }

    $debutActivite->id_statut = $new;
    $debutActivite->save();

    // create history (use null for invalid zero)
    ImmobilierStatutHistory::create([
        'immobilier_id'      => $debutActivite->immobilier_id,
        'debut_activite_id'  => $debutActivite->id_debut,
        'from_statut_id'     => $old ?: null,
        'to_statut_id'       => $new ?: null,
        'changed_by'         => Auth::id() ?? null,
        'commentaire'        => $request->input('commentaire_motif') ?? null,
    ]);

    // Send notification for ALL types
    $user = $debutActivite->immobilier->utilisateur;
    if ($user) {
        $statusMap = [
            1 => 'accepted',
            3 => 'rejected',
            4 => 'incomplete',
            5 => 'deferred',
        ];
        $normType = $statusMap[$new] ?? 'status_changed';

        $translationParams = [];
        if ($normType === 'accepted') {
            $translationParams['date'] = Carbon::parse($debutActivite->date_debut_activite ?? now())->toDateString();
            $translationParams['reference'] = $debutActivite->id_debut;
        } elseif ($normType === 'rejected') {
            $translationParams['reason'] = $request->input('commentaire_motif') ?? '';
            $translationParams['reference'] = $debutActivite->id_debut;
        } elseif ($normType === 'incomplete') {
            $translationParams['missing'] = $request->input('commentaire_acceptation') ?? '';
            $translationParams['reference'] = $debutActivite->id_debut;
        } elseif ($normType === 'deferred') {
            $translationParams['note'] = $request->input('commentaire_avis') ?? '';
            $translationParams['reference'] = $debutActivite->id_debut;
        } else {
            $translationParams['reference'] = $debutActivite->id_debut;
        }

        // keep your existing mail flow (accepted / rejected)
        try {
            if ($new == 3 && $request->commentaire_motif) {
                Mail::to($user->email)->send(
                    new DebutActiviteStatutMail('refuse', $user, null, $request->commentaire_motif)
                );
            } elseif ($new == 1) {
                $dateDebut = Carbon::now()->addDays(15);
                Mail::to($user->email)->send(
                    new DebutActiviteStatutMail('accepte', $user, $dateDebut)
                );
            }
        } catch (\Exception $e) {
            \Log::error("Mail send error DebutActivite toggleStatut: ".$e->getMessage());
        }

        // database notification (translation-aware)
        $user->notify(new DebutActiviteStatutNotification($normType, $translationParams));
    } else {
        \Log::warning("Aucun utilisateur trouvé pour DebutActivite ID {$id}");
    }

    return redirect()->back()->with('success', 'تم تغيير حالة الطلب بنجاح');
}

*/


 /*       public function toggleStatut(Request $request, $id)
    {
        $debutActivite = DebutActivite::with('immobilier.utilisateur')->findOrFail($id);

        $debutActivite->id_statut = $request->id_statut;

        if (in_array($request->id_statut, [1, 3])) {
            $debutActivite->etat_formulaire = 'reponse';
        }

        $user = $debutActivite->immobilier->utilisateur;

        if ($request->id_statut == 3 && $request->commentaire_motif) {
            $debutActivite->commentaire_motif = $request->commentaire_motif;

            Mail::to($user->email)->send(
                new DebutActiviteStatutMail('refuse', $user, null, $request->commentaire_motif)
            );

          $user->notify(new DebutActiviteStatutNotification('rejected', $request->commentaire_motif));

        } elseif ($request->id_statut == 1) {
            $dateDebut = Carbon::now()->addDays(15);

            Mail::to($user->email)->send(
                new DebutActiviteStatutMail('accepte', $user, $dateDebut)
            );

            $user->notify(new DebutActiviteStatutNotification('accepted', $dateDebut));
        }

        $debutActivite->save();

        return redirect()->back()->with('success', 'تم تغيير حالة الطلب بنجاح');
    }
*/

public function show($id)
{
    $debutActivite = DebutActivite::with([
        'immobilier.utilisateur',
        'immobilier.gouvernorat',
        'activiteJeuneEnfant.utilisateur',
        'activiteJeuneEnfant.gouvernorat',
        'insts.utilisateur',
        'insts.gouvernorat',
        'projet_debut.utilisateur',
        'projet_debut.gouvernorat',
        'sport.utilisateur',
        'sport.gouvernorat',
        'statutHistories.fromStatut',
        'statutHistories.toStatut',
        'statutHistories.changer',
    ])->findOrFail($id);

    $immobilier_id = $debutActivite->immobilier_id;
    $statuts = TpStatut::orderBy('id_statut')->get();
    
    // Récupérez l'utilisateur via l'accesseur
    $utilisateur = $debutActivite->utilisateur;
    
    // Récupérez le gouvernorat via l'accesseur (si vous l'avez créé)
    // OU déterminez-le manuellement
    $gouvernorat = null;
    
    // Essayer différentes relations pour trouver le gouvernorat
    if ($debutActivite->immobilier && $debutActivite->immobilier->gouvernorat) {
        $gouvernorat = $debutActivite->immobilier->gouvernorat;
    } elseif ($debutActivite->projet_debut && $debutActivite->projet_debut->gouvernorat) {
        $gouvernorat = $debutActivite->projet_debut->gouvernorat;
    } elseif ($debutActivite->activiteJeuneEnfant && $debutActivite->activiteJeuneEnfant->gouvernorat) {
        $gouvernorat = $debutActivite->activiteJeuneEnfant->gouvernorat;
    } elseif ($debutActivite->insts && $debutActivite->insts->gouvernorat) {
        $gouvernorat = $debutActivite->insts->gouvernorat;
    } elseif ($debutActivite->sport && $debutActivite->sport->gouvernorat) {
        $gouvernorat = $debutActivite->sport->gouvernorat;
    }
    
    // AJOUTEZ $utilisateur et $gouvernorat au compact()
    return view('backoffice.investissement.gestion_salle_sport.debut_activite.show', 
        compact('debutActivite', 'immobilier_id', 'statuts', 'utilisateur', 'gouvernorat'));
}




/*public function pdf($id)
{
    $debutActivite = DebutActivite::with('immobilier.utilisateur')->findOrFail($id);
    $data = compact('debutActivite');

    $html = view('backoffice.investissement.gestion_salle_sport.debut_activite.pdf', $data)->render();

    $mpdf = new Mpdf([
        'mode' => 'utf-8',
        'format' => 'A4',
        'default_font' => 'dejavusans',
        'directionality' => 'rtl',
        'autoScriptToLang' => true,
        'autoLangToFont' => true,
    ]);

    $mpdf->setFooter('{PAGENO} / {nb}');
    $mpdf->WriteHTML($html);

    return $mpdf->Output('debut_activite.pdf', 'I');
}*/

public function pdf($id)
{
    ini_set('pcre.backtrack_limit', '10000000');
    ini_set('pcre.recursion_limit', '10000000');

    // Chargez toutes les relations possibles
    $debutActivite = DebutActivite::with([
        'immobilier.utilisateur',
        'immobilier.gouvernorat',
        'activiteJeuneEnfant.utilisateur',
        'activiteJeuneEnfant.gouvernorat',
        'insts.utilisateur',
        'insts.gouvernorat',
        'projet_debut.utilisateur',
        'projet_debut.gouvernorat',
        'sport.utilisateur',
        'sport.gouvernorat',
    ])->findOrFail($id);

    // Récupérez l'utilisateur via l'accesseur
    $utilisateur = $debutActivite->utilisateur;
    
    // Récupérez le gouvernorat
    $gouvernorat = null;
    if ($debutActivite->immobilier && $debutActivite->immobilier->gouvernorat) {
        $gouvernorat = $debutActivite->immobilier->gouvernorat;
    } elseif ($debutActivite->projet_debut && $debutActivite->projet_debut->gouvernorat) {
        $gouvernorat = $debutActivite->projet_debut->gouvernorat;
    } elseif ($debutActivite->activiteJeuneEnfant && $debutActivite->activiteJeuneEnfant->gouvernorat) {
        $gouvernorat = $debutActivite->activiteJeuneEnfant->gouvernorat;
    } elseif ($debutActivite->insts && $debutActivite->insts->gouvernorat) {
        $gouvernorat = $debutActivite->insts->gouvernorat;
    } elseif ($debutActivite->sport && $debutActivite->sport->gouvernorat) {
        $gouvernorat = $debutActivite->sport->gouvernorat;
    }

    $data = compact('debutActivite', 'utilisateur', 'gouvernorat');

    $html = view('backoffice.investissement.gestion_salle_sport.debut_activite.pdf', $data)->render();

    $mpdf = new Mpdf([
        'mode' => 'utf-8',
        'format' => 'A4',
        'default_font' => 'dejavusans',
        'directionality' => 'rtl',
        'autoScriptToLang' => true,
        'autoLangToFont' => true,
    ]);

    $mpdf->setFooter('{PAGENO} / {nb}');
    $mpdf->WriteHTML($html);

    return $mpdf->Output('debut_activite.pdf', 'I');
}


/*public function pdf($id)
{
    $debutActivite = DebutActivite::with('immobilier.utilisateur')->findOrFail($id);

    $mpdf = new \Mpdf\Mpdf([
        'mode' => 'utf-8',
        'format' => 'A4',
        'default_font' => 'dejavusans',
        'directionality' => 'rtl',
        'autoScriptToLang' => true,
        'autoLangToFont' => true,
    ]);

    $mpdf->setFooter('{PAGENO} / {nb}');

    // ⚠️ écrire le HTML en morceaux
    $mpdf->WriteHTML(view(
        'backoffice.investissement.gestion_salle_sport.debut_activite.pdf_header',
        compact('debutActivite')
    )->render());

    $mpdf->WriteHTML(view(
        'backoffice.investissement.gestion_salle_sport.debut_activite.pdf_body',
        compact('debutActivite')
    )->render());

    $mpdf->WriteHTML(view(
        'backoffice.investissement.gestion_salle_sport.debut_activite.pdf_documents',
        compact('debutActivite')
    )->render());

    return $mpdf->Output('debut_activite.pdf', 'I');
}
*/

    public function destroy($id)
{
    $debutActivite = DebutActivite::findOrFail($id);

    // Liste des fichiers à supprimer
    $files = [
        'preuve_propriete_location',
        'plan_architectural',
        'declaration_investissement',
        'identification',
        'extrait_registre_national_entreprise',
        'certificat_prevention',
        'contrat_assurance',
        'approbation_autorite_minicipale',
    ];

    foreach ($files as $fileField) {
        if ($debutActivite->$fileField && Storage::disk('public')->exists($debutActivite->$fileField)) {
            Storage::disk('public')->delete($debutActivite->$fileField);
        }
    }

    $debutActivite->delete();

    return redirect()->route('admin.debut_activite.index')->with('success', 'تم حذف الاستمارة بنجاح.');
}



//////////////////////////////////////////******  Front   ******** //////////////////////////////////////////////////////////////

public function index2(Request $request)
    {
        $debutActivites = DebutActivite::with('immobilier.utilisateur')
            ->orderByDesc('created_at')
            ->paginate(10);

        return view('FrontOffice.investissement.gestion_salle_sport.debut_activite.index', compact('debutActivites'));
    }

    public function create2(Request $request)
    {
        $immobilier_id = $request->query('immobilier_id', null);
        return view('FrontOffice.investissement.gestion_salle_sport.debut_activite.create', compact('immobilier_id'));
    }

    public function store2(Request $request)
    {
        $validated = $request->validate([
            'immobilier_id' => 'required|exists:immobilier,id_imm',
            'date_debut_activite' => 'required|date',            
            'preuve_propriete_location' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'plan_architectural' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'declaration_investissement' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'identification' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'extrait_registre_national_entreprise' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'certificat_prevention' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'contrat_assurance' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'approbation_autorite_minicipale' => 'required|file|mimes:pdf,jpg,jpeg,png|max:2048',
        ]);

        $uploads = [];
        foreach ([
            'preuve_propriete_location',
            'plan_architectural',
            'declaration_investissement',
            'identification',
            'extrait_registre_national_entreprise',
            'certificat_prevention',
            'contrat_assurance',
            'approbation_autorite_minicipale',
        ] as $fileField) {
            if ($request->hasFile($fileField)) {
                $uploads[$fileField] = $request->file($fileField)->store('uploads/debut_activite', 'public');
            }
        }

        DebutActivite::create([
            'immobilier_id' => $request->immobilier_id,
            'date_debut_activite' => $request->date_debut_activite,
            'preuve_propriete_location' => $uploads['preuve_propriete_location'] ?? null,
            'plan_architectural' => $uploads['plan_architectural'] ?? null,
            'declaration_investissement' => $uploads['declaration_investissement'] ?? null,
            'identification' => $uploads['identification'] ?? null,
            'extrait_registre_national_entreprise' => $uploads['extrait_registre_national_entreprise'] ?? null,
            'certificat_prevention' => $uploads['certificat_prevention'] ?? null,
            'contrat_assurance' => $uploads['contrat_assurance'] ?? null,
            'approbation_autorite_minicipale' => $uploads['approbation_autorite_minicipale'] ?? null,
        ]);

        return redirect()->route('debut_activite.create2')->with('success', 'تم تسجيل بداية النشاط بنجاح ');
    }

public function verifierIdentite2(Request $request)
{
    $request->validate([
        'id_type_identite' => 'required|exists:tp_type_identite_pers,id_type',
        'identifiant' => 'required|string',
        'immobilier_id' => 'required|exists:immobilier,id_imm'
    ]);

    $idType = $request->id_type_identite;
    $identifiant = $request->identifiant;
    $immobilier_id = $request->immobilier_id;

    $immobilier = Immobilier::with('utilisateur','gouvernorat')->find($immobilier_id);
    if(!$immobilier) return response()->json(['success' => false]);

    $user = $immobilier->utilisateur;
    $match = false;

    if($idType == 1 && $user->cin == $identifiant) $match = true;
    if($idType == 2 && $user->passport == $identifiant) $match = true;
    if($idType == 3 && $user->num_fiscal == $identifiant) $match = true;

    if($match) {
        return response()->json([
            'success' => true,
            'user' => $user,
            'immobilier' => [
                'id_imm' => $immobilier->id_imm,
                'gouvernorat_nom_ar' => $immobilier->gouvernorat->nom_ar ?? null
            ]
        ]);
    }

    return response()->json(['success' => false]);
}

        public function edit2($id)
    {
        $debutActivite = DebutActivite::with('immobilier.utilisateur', 'immobilier.gouvernorat')->findOrFail($id);
        $immobilier_id = $debutActivite->immobilier_id;

        return view('FrontOffice.investissement.gestion_salle_sport.debut_activite.edit', compact('debutActivite', 'immobilier_id'));
    }

    public function update2(Request $request, $id)
{
    $debutActivite = DebutActivite::findOrFail($id);

    // Validation
    $validated = $request->validate([
        'immobilier_id' => 'required|exists:immobilier,id_imm',
        'date_debut_activite' => 'required|date',
        'id_statut' => 'nullable|in:1,3',
        'commentaire_motif' => 'nullable|string|required_if:id_statut,3|max:255',
        'preuve_propriete_location' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'plan_architectural' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'declaration_investissement' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'identification' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'extrait_registre_national_entreprise' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'certificat_prevention' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'contrat_assurance' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
        'approbation_autorite_minicipale' => 'nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
    ]);

    // Gestion des fichiers uploadés
    $uploads = [];
    foreach ([
        'preuve_propriete_location',
        'plan_architectural',
        'declaration_investissement',
        'identification',
        'extrait_registre_national_entreprise',
        'certificat_prevention',
        'contrat_assurance',
        'approbation_autorite_minicipale',
    ] as $fileField) {
        if ($request->hasFile($fileField)) {
            if ($debutActivite->$fileField) {
                Storage::disk('public')->delete($debutActivite->$fileField);
            }
            $uploads[$fileField] = $request->file($fileField)->store('uploads/debut_activite', 'public');
        }
    }

    // Mise à jour de l'enregistrement
    $debutActivite->update(array_merge(
        [
            'immobilier_id' => $request->immobilier_id,
            'date_debut_activite' => $request->date_debut_activite,
            'id_statut' => $request->id_statut,                 // <- Ajout du statut
            'commentaire_motif' => $request->commentaire_motif, // <- Ajout du motif
        ],
        $uploads
    ));

    // Envoi du mail selon le statut
    $user = $debutActivite->immobilier->utilisateur;
    if ($request->id_statut == 3 && $request->commentaire_motif) {
        Mail::to($user->email)->send(
            new DebutActiviteStatutMail('refuse', $user, null, $request->commentaire_motif)
        );
    } elseif ($request->id_statut == 1) {
        Mail::to($user->email)->send(
            new DebutActiviteStatutMail('accepte', $user)
        );
    }

    return redirect()->route('debut_activite.index2')
                     ->with('success', 'تم تحديث بيانات بداية النشاط بنجاح');
}


        public function toggleStatut2(Request $request, $id)
{
    $debutActivite = DebutActivite::with('immobilier.utilisateur')->findOrFail($id);

    // Supprimer la restriction sur le statut actuel
    $debutActivite->id_statut = $request->id_statut;
    $user = $debutActivite->immobilier->utilisateur;

    if ($request->id_statut == 3 && $request->commentaire_motif) {
        $debutActivite->commentaire_motif = $request->commentaire_motif;

        Mail::to($user->email)->send(
            new DebutActiviteStatutMail('refuse', $user, null, $request->commentaire_motif)
        );

       $user->notify(new DebutActiviteStatutNotification('rejected', $request->commentaire_motif));

    } elseif ($request->id_statut == 1) {
        $dateDebut = Carbon::now()->addDays(15);

        Mail::to($user->email)->send(
            new DebutActiviteStatutMail('accepte', $user, $dateDebut)
        );

        $user->notify(new DebutActiviteStatutNotification('accepted', $dateDebut));
    }

    $debutActivite->save();

    return redirect()->back()->with('success', 'تم تغيير حالة الطلب بنجاح');
}


public function show2($id)
    {
        $debutActivite = DebutActivite::with('immobilier.utilisateur', 'immobilier.gouvernorat')->findOrFail($id);
        $immobilier_id = $debutActivite->immobilier_id;

        return view('FrontOffice.investissement.gestion_salle_sport.debut_activite.show', compact('debutActivite', 'immobilier_id'));
    }

    public function destroy2($id)
{
    $debutActivite = DebutActivite::findOrFail($id);

    // Liste des fichiers à supprimer
    $files = [
        'preuve_propriete_location',
        'plan_architectural',
        'declaration_investissement',
        'identification',
        'extrait_registre_national_entreprise',
        'certificat_prevention',
        'contrat_assurance',
        'approbation_autorite_minicipale',
    ];

    foreach ($files as $fileField) {
        if ($debutActivite->$fileField && Storage::disk('public')->exists($debutActivite->$fileField)) {
            Storage::disk('public')->delete($debutActivite->$fileField);
        }
    }

    $debutActivite->delete();

    return redirect()->route('debut_activite.index2')->with('success', 'تم حذف الاستمارة بنجاح.');
}

}
