<?php

namespace App\Http\Controllers\Financement;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Storage;
use Illuminate\Http\Request;
use App\Models\Projet;
use App\Models\TypeFormulaire;
use App\Models\TpTypeDocument;
use App\Models\DocumentsFinancement;
use App\Models\TpStatut;
use App\Models\DocumentsFinancementList;
use App\Mail\StatutDocumentChanged;
use App\Notifications\StatutDocumentNotification;
use App\Models\Utilisateur;
use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use App\Models\Association;
use App\Models\TypeFinancement;
use App\Models\DemandeFinancement;
use App\Models\Superviseur;
use App\Models\ActivitePhase;
use App\Models\EstimationBudget;
use App\Models\ContributeurProjet;
use App\Models\PosteDepense;
use App\Models\TypeDocument;
use Illuminate\Support\Collection;
use App\Models\ImmobilierStatutHistory;
use Illuminate\Support\Facades\Log;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Mpdf\Mpdf;
use Illuminate\Support\Str;

class DocumentFinancement2Controller extends Controller
{
    public function index(Request $request)
{
    $query = DocumentsFinancementList::with([
        'statut1',
        'projet.superviseur',
        'projet.demande'
    ])
    ->where('brouillon', false)
    ->orderBy('id_doc_list', 'desc');

    // 🔍 Recherche par nom du projet
    if ($request->filled('nom_projet')) {
        $query->whereHas('projet', function ($q) use ($request) {
            $q->where('nom_projet', 'like', '%' . $request->nom_projet . '%');
        });
    }

    // 🔍 Recherche par type de financement
    if ($request->filled('type_demande')) {
        $query->whereHas('projet.demande', function ($q) use ($request) {
            $q->where('type_financement_id', $request->type_demande);
        });
    }

    // 🔍 Recherche par superviseur
    if ($request->filled('nom_superviseur')) {
        $query->whereHas('projet.superviseur', function ($q) use ($request) {
            $q->where('nom_prenom', 'like', '%' . $request->nom_superviseur . '%');
        });
    }

    $documents = $query->paginate(10)->appends($request->query());

    $type_financement = TypeFinancement::all();

    return view(
        'backoffice.financement.documents_financement.index',
        compact('documents', 'type_financement')
    );
}


public function exportPdf(Request $request)
{
    $documents = $this->baseQuery($request)->get();

    $html = view(
        'backoffice.financement.documents_financement.exports.documents_pdf',
        compact('documents')
    )->render();

    $mpdf = new \Mpdf\Mpdf([
        'mode' => 'utf-8',
        'format' => 'A4',
        'default_font' => 'dejavusans',
        'directionality' => 'rtl',
    ]);

    $mpdf->WriteHTML($html);

    return response($mpdf->Output('documents_financement.pdf', 'S'))
        ->header('Content-Type', 'application/pdf');
}





public function exportExcel(Request $request)
{
    $documents = $this->baseQuery($request)->get();

    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->setRightToLeft(true);

    // Header
    $sheet->fromArray([
        '',
        'اسم المشروع',
        'الحالة',
    ], null, 'A1');

    $sheet->getStyle('A1:C1')->getFont()->setBold(true);

    $row = 2;
    foreach ($documents as $i => $doc) {
        $sheet->setCellValue('A'.$row, $i + 1);
        $sheet->setCellValue('B'.$row, $doc->projet?->nom_projet);
        
        $sheet->setCellValue('C'.$row, $doc->statut1?->statut_ar);
        $row++;
    }

    foreach (range('A', 'C') as $col) {
        $sheet->getColumnDimension($col)->setAutoSize(true);
    }

    $writer = new Xlsx($spreadsheet);

    return response()->streamDownload(function () use ($writer) {
        $writer->save('php://output');
    }, 'documents_financement.xlsx');
}


    public function brouillons()
{
    $documents = DocumentsFinancementList::with('statut1', 'statut2', 'projet', 'user')
        ->where('id_user', auth()->id())
        ->where('brouillon', true) 
        ->orderBy('id_doc_list', 'desc')
        ->paginate(10);

    return view('backoffice.financement.documents_financement.brouillons', compact('documents'));
}


    public function create(Request $request)
    {
        $formulaire = TypeFormulaire::find(6);
        $type_financement = TypeFinancement::all();

        $association = session('association_id')
            ? Association::with('demandes','projets')->find(session('association_id'))
            : null;

        $selectedTypes = $association
            ? $association->demandes->pluck('type_financement_id')->toArray()
            : [];

        $formulaire2 = TypeFormulaire::find(7);
        $associations = Association::all();

        $demande_id = $request->demande_id;
        $demande = DemandeFinancement::with('association')->find($demande_id);

        $selectedAssociationId = $demande && $demande->association ? $demande->association->id_association : null;
        $selectedAssociationName = $demande && $demande->association ? $demande->association->nom_association : null;

        $formulaire3 = TypeFormulaire::find(8);
        $typedocum = TpTypeDocument::all();
        $id_projet = $request->query('projet_id');
        $documents = DocumentsFinancementList::where('id_projet', $id_projet)->get();

        return view('backoffice.financement.documents_financement.create', compact(
            'formulaire2','associations','demande_id','demande',
            'formulaire','type_financement','association','selectedTypes','selectedAssociationId','selectedAssociationName',
            'formulaire3','typedocum','id_projet','documents'
        ));
    }

    /*public function storeAll(Request $request)
    {
        DB::beginTransaction();

        try {
            $isBrouillon = $request->brouillon == 1;

            if ($isBrouillon) {
                $rules = [
                    'nom_association' => 'required|string|max:255',
                ];
            } else {
                $rules = [
                    // Association
                    'nom_association' => 'required|string|max:255',
                    'adresse' => 'required|string|max:255',
                    'code_postal' => 'required|string|max:20',
                    'tel' => 'required|string|max:50',
                    'fax' => 'required|string|max:50',
                    'date_creation' => 'required|date',
                    'num_visa' => 'required|string|max:100',
                    'date_visa' => 'required|date',
                    'num_identification_fiscale' => 'required|string|max:100',
                    'num_compte_courant' => 'required|string|max:100',
                    'banque' => 'required|string|max:255',
                    'adresse_mail' => 'required|email|max:255',
                    'adresse_site_internet' => 'required|string|max:255',
                    'nom_president_association' => 'required|string|max:255',
                    'tel_personnel' => 'required|string|max:50',
                    'num_membre_bureau_national_a' => 'required|integer',
                    'num_bureaux_regionaux' => 'required|integer',
                    'num_total_membre' => 'required|integer',
                    'types_financement' => 'required|array|min:1',
                    'id_formulaire' => 'required|integer|exists:tp_type_formulaire,id_type',

                    // Superviseur
                    'nom_prenom_sup' => 'required|string|max:100',
                    'profession_sup' => 'required|string|max:100',
                    'role_sup'       => 'required|string|max:100',
                    'tel_sup'        => 'required|string|max:12',
                    'email_sup'      => 'required|email|max:255',

                    // Projet
                    'nom_projet'               => 'required|string|max:255',
                    'justification_realisation'=> 'required|string|max:255',
                    'objectives'               => 'required|string',
                    'public'                   => 'required|string|max:255',
                    'nombre_spectateur'        => 'required|integer|min:1',
                    'tranch_age_min'           => 'required|integer|min:0',
                    'tranch_age_max'           => 'required|integer|gte:tranch_age_min',
                    'parties_realisation'      => 'required|string',
                    'resultat_quantitatif'     => 'required|string',
                    'resultat_qualitatif'      => 'required|string',
                    'perspectives'             => 'required|string',

                    // Phases
                    'phases.*.description'         => 'required|string|max:200',
                    'phases.*.completion_date'     => 'required|date',
                    'phases.*.completion_location' => 'required|string|max:100',

                    // Budget
                    'budget.*.total_cost'      => 'required|numeric|min:0',
                    'budget.*.self_percent'    => 'required|numeric|min:0|max:100',
                    'budget.*.self_amount'     => 'required|numeric|min:0',
                    'budget.*.ministry_amount' => 'required|numeric|min:0',
                    'budget.*.ministry_percent'=> 'required|numeric|min:0|max:100',
                    'budget.*.supporters.*.name'   => 'required|string|max:255',
                    'budget.*.supporters.*.amount' => 'required|numeric|min:0',
                    'budget.*.supporters.*.percent'=> 'required|numeric|min:0|max:100',

                    // Dépenses
                    'depenses.*.libelle_depense' => 'required|string|max:200',
                    'depenses.*.description'     => 'required|string|max:255',
                    'depenses.*.cout'            => 'required|numeric|min:0',

                    // Documents
                    'doc_fin.*.id_doc' => 'required|integer|exists:tp_type_document,id_type_doc',
                    'doc_fin.*.file' => 'required|file|mimes:pdf,jpg,jpeg,png,doc,docx|max:2048',
                    'doc_fin.*.remarques' => 'required|string|max:100',
                ];
            }

            $request->validate($rules);

            $request->merge([
                'types_financement' => $request->types_financement ?? [],
                'phases' => $request->phases ?? [],
                'budget' => $request->budget ?? [],
                'depenses' => $request->depenses ?? [],
                'doc_fin' => $request->doc_fin ?? [],
            ]);

            $association = Association::create($request->only([
                'nom_association','adresse','code_postal','tel','fax',
                'date_creation','num_visa','date_visa','num_identification_fiscale',
                'num_compte_courant','banque','adresse_mail','adresse_site_internet',
                'nom_president_association','tel_personnel','num_membre_bureau_national_a',
                'num_bureaux_regionaux','num_total_membre','id_formulaire'
            ]));

            $demande = null;
            if (!empty($request->types_financement)) {
                foreach ($request->types_financement as $typeFinId) {
                    $demande = DemandeFinancement::create([
                        'association_id'      => $association->id_association,
                        'type_financement_id' => $typeFinId,
                        'type_formulaire_id'  => $request->id_formulaire,
                        'id_user'             => auth()->id(),
                    ]);
                }
            }

            $superviseur = Superviseur::create($request->only([
                'nom_prenom_sup','profession_sup','role_sup','tel_sup','email_sup'
            ]));

            $projet = Projet::create([
                'id_superviseur'          => $superviseur->id_sup,
                'id_formulaire'           => $request->id_formulaire,
                'id_demande'              => $demande?->id_demande_fin, 
                'id_user'                 => auth()->id(),
                'nom_projet'              => $request->nom_projet,
                'justification_realisation'=> $request->justification_realisation,
                'objectives'              => $request->objectives,
                'public'                  => $request->public,
                'nombre_spectateur'       => $request->nombre_spectateur,
                'tranch_age_min'          => $request->tranch_age_min,
                'tranch_age_max'          => $request->tranch_age_max,
                'parties_realisation'     => $request->parties_realisation,
                'resultat_quantitatif'    => $request->resultat_quantitatif,
                'resultat_qualitatif'     => $request->resultat_qualitatif,
                'perspectives'            => $request->perspectives,
            ]);

            foreach ($request->phases as $phase) {
                if (!empty($phase['description'])) {
                    ActivitePhase::create([
                        'id_projet' => $projet->id_projet,
                        'description' => $phase['description'],
                        'completion_date' => $phase['completion_date'] ?? null,
                        'completion_location' => $phase['completion_location'] ?? null,
                    ]);
                }
            }

            $estimation = null;
            foreach ($request->budget as $budget) {
                $estimation = EstimationBudget::create([
                    'projet_id'                     => $projet->id_projet,
                    'cout_total_estime'             => $budget['total_cost'] ?? 0,
                    'financement_propre_pourcentage'=> $budget['self_percent'] ?? 0,
                    'financement_propre_montant'    => $budget['self_amount'] ?? 0,
                    'aide_ministere_montant'        => $budget['ministry_amount'] ?? 0,
                    'aide_ministere_pourcentage'    => $budget['ministry_percent'] ?? 0,
                ]);

                if (!empty($budget['supporters'])) {
                    foreach ($budget['supporters'] as $supporter) {
                        if (!empty($supporter['name'])) {
                            ContributeurProjet::create([
                                'id_estimation_budget' => $estimation->id_estimation,
                                'nom' => $supporter['name'],
                                'montant' => $supporter['amount'] ?? 0,
                                'pourcentage' => $supporter['percent'] ?? 0,
                            ]);
                        }
                    }
                }
            }

            foreach ($request->depenses as $depense) {
                if (!empty($depense['libelle_depense'])) {
                    PosteDepense::create([
                        'id_estimation_budget' => $estimation?->id_estimation,
                        'libelle_depense' => $depense['libelle_depense'],
                        'description' => $depense['description'] ?? '',
                        'cout' => $depense['cout'] ?? 0,
                    ]);
                }
            }

            $docList = DocumentsFinancementList::create([
                'id_projet'     => $projet->id_projet,
                'id_formulaire' => $request->id_formulaire,
                'id_statut1'    => 2,
                'id_statut2'    => null,
                'id_user'       => auth()->id(),
                'brouillon'     => $request->brouillon ? 1 : 0,
            ]);

            foreach ($request->doc_fin as $doc) {
                if (!empty($doc['id_doc'])) {
                    $filePath = isset($doc['file']) ? $doc['file']->store('documents_financement', 'public') : null;
                    DocumentsFinancement::create([
                        'id_doc'      => $doc['id_doc'],
                        'file'        => $filePath,
                        'remarques'   => $doc['remarques'] ?? null,
                        'id_doc_list' => $docList->id_doc_list,
                    ]);
                }
            }

            DB::commit();
            return redirect()->route('doc_fin.index')
                ->with('success', 'تم إنشاء النموذج بنجاح');
        }

        catch (\Exception $e) {
            DB::rollBack();
            return back()->withErrors(['error' => 'حدث خطأ أثناء الحفظ: ' . $e->getMessage()])
                        ->withInput();
        }
    }*/		 
	public function storeAll(Request $request)    {   
	$isBrouillon = $request->brouillon == 1;          
	if ($isBrouillon) {               
	$rules = [                  
	'nom_association' => 'required|string|max:255',	
	'types_financement' => 'required|array|min:1',     

	];				$messages = [   
	'nom_association.required' => 'الرجاء إدخال اسم الجمعية.',	

	'types_financement.required' => 'الرجاء اختيار نوع التمويل.',   
	];            } else {                $rules = [                 
	// Association                    
	'nom_association' => 'required|string|max:255', 
	'adresse' => 'required|string|max:255',                
    'code_postal' => 'required|string|max:20',                    
	'tel' => 'required|string|max:50',                    
	'fax' => 'required|string|max:50',                
	'date_creation' => 'required|date',                   
	'num_visa' => 'required|string|max:100',                   
	'date_visa' => 'required|date',                   
	'num_identification_fiscale' => 'required|string|max:100',     
	'num_compte_courant' => 'required|string|max:100',               
	'banque' => 'required|string|max:255',                  
	'adresse_mail' => 'required|email|max:255',               
	'adresse_site_internet' => 'required|string|max:255',      
	'nom_president_association' => 'required|string|max:255',    
	'tel_personnel' => 'required|string|max:50',                  
	'num_membre_bureau_national_a' => 'required|integer',         
	'num_bureaux_regionaux' => 'required|integer',                 
	'num_total_membre' => 'required|integer',                   
	'types_financement' => 'required|array|min:1',            
	'id_formulaire' => 'required|integer|exists:tp_type_formulaire,id_type',    
	// Superviseur                  
	'nom_prenom_sup' => 'required|string|max:100', 
	'profession_sup' => 'required|string|max:100',         
	'role_sup'       => 'required|string|max:100',            
	'tel_sup'        => 'required|string|max:12',             
	'email_sup'      => 'required|email|max:255',              
	// Projet                 
	'nom_projet' => 'required|string|max:255', 
	'justification_realisation'=> 'required|string|max:255',      
	'objectives'               => 'required|string',                
    'public'                   => 'required|string|max:255',                  
	'nombre_spectateur'        => 'required|integer|min:1',                
    'tranch_age_min'           => 'required|integer|min:0',               
	'tranch_age_max'           => 'required|integer|gte:tranch_age_min',     
	'parties_realisation'      => 'required|string',                  
	'resultat_quantitatif'     => 'required|string',                  
	'resultat_qualitatif'      => 'required|string',                   
	'perspectives'             => 'required|string',                   
	// Phases                   
	'phases.*.description' => 'required|string|max:200',                  
	'phases.*.completion_date'     => 'required|date',                    
	'phases.*.completion_location' => 'required|string|max:100',                    
	// Budget                    
	'budget.*.total_cost'      => 'required|numeric|min:0',                   
	'budget.*.self_percent'    => 'required|numeric|min:0|max:100',                
    'budget.*.self_amount'     => 'required|numeric|min:0',                   
	'budget.*.ministry_amount' => 'required|numeric|min:0',                  
	'budget.*.ministry_percent'=> 'required|numeric|min:0|max:100',       
	'budget.*.supporters.*.name'   => 'required|string|max:255',            
	'budget.*.supporters.*.amount' => 'required|numeric|min:0',             
	'budget.*.supporters.*.percent'=> 'required|numeric|min:0|max:100',     
	// Dépenses                   
	'depenses.*.libelle_depense' => 'required|string|max:200',                   
	'depenses.*.description'     => 'required|string|max:255',   
	'depenses.*.cout'            => 'required|numeric|min:0',                    
	// Documents                    
	'doc_fin.*.id_doc' => 'required|integer|exists:tp_type_document,id_type_doc',              
	'doc_fin.*.file' => 'required|file|mimes:pdf,jpg,jpeg,png,doc,docx|max:2048',      
	];								
	$messages = [    
	// Association   
	'nom_association.required' => 'الرجاء إدخال اسم الجمعية.',   
	'adresse.required' => 'الرجاء إدخال العنوان.',   
	'code_postal.required' => 'الرجاء إدخال الرمز البريدي.',  
	'tel.required' => 'الرجاء إدخال رقم الهاتف.',    
	
	'fax.required' => 'الرجاء إدخال رقم الفاكس.',    
	'date_creation.required' => 'الرجاء إدخال تاريخ التأسيس.',  
	'parties_realisation' => 'الرجاء إدخال الأطراف المشاركة في الإنجاز.',
    'resultat_quantitatif' => 'الرجاء إدخال  النتائج الكمية.',  
	'resultat_qualitatif' => 'الرجاء إدخال  النتائج النوعية.',  
	'perspectives' => 'الرجاء إدخال الآفاق المنتظرة.',   
	'num_visa.required' => 'الرجاء إدخال رقم التأشيرة.',    
	'date_visa.required' => 'الرجاء إدخال تاريخ التأشيرة.', 
	'num_identification_fiscale.required' => 'الرجاء إدخال المعرف الجبائي.', 
	'num_compte_courant.required' => 'الرجاء إدخال رقم الحساب الجاري.',   
	'banque.required' => 'الرجاء إدخال اسم البنك.',   
	'adresse_mail.required' => 'الرجاء إدخال البريد الإلكتروني.', 
	'adresse_site_internet.required' => 'الرجاء إدخال الموقع الإلكتروني.', 
	'nom_president_association.required' => 'الرجاء إدخال اسم رئيس الجمعية.',  
	'tel_personnel.required' => 'الرجاء إدخال الهاتف الشخصي.',  
	'num_membre_bureau_national_a.required' => 'الرجاء إدخال عدد أعضاء المكتب الوطني.', 
	'num_bureaux_regionaux.required' => 'الرجاء إدخال عدد المكاتب الجهوية.',  
	'num_total_membre.required' => 'الرجاء إدخال العدد الجملي للأعضاء.',   
	'types_financement.required' => 'الرجاء اختيار نوع التمويل.',  
	'id_formulaire.required' => 'الرجاء اختيار نوع الاستمارة.',   
	// Superviseur    
	'nom_prenom_sup.required' => 'الرجاء إدخال اسم المشرف.',  
	'profession_sup.required' => 'الرجاء إدخال مهنة المشرف.', 
	'role_sup.required' => 'الرجاء إدخال دور المشرف.',   
	'tel_sup.required' => 'الرجاء إدخال رقم هاتف المشرف.',  
	'email_sup.required' => 'الرجاء إدخال بريد المشرف.',   
	// Projet    
	'nom_projet.required' => 'الرجاء إدخال اسم المشروع.',  
	'justification_realisation.required' => 'الرجاء إدخال مبررات الإنجاز.',
    'objectives.required' => 'الرجاء إدخال الأهداف.',   
	'public.required' => 'الرجاء إدخال الفئة المستهدفة.',  
	'nombre_spectateur.required' => 'الرجاء إدخال عدد المتفرجين.',  
	'tranch_age_min.required' => 'الرجاء إدخال الحد الأدنى للعمر.',   
	'tranch_age_max.required' => 'الرجاء إدخال الحد الأقصى للعمر.',    
	'tranch_age_max.gte' => 'يجب أن يكون الحد الأقصى للعمر أكبر من الحد الأدنى.',  
	// Phases    
	'phases.*.description.required' => 'الرجاء إدخال وصف المرحلة.',
    'phases.*.completion_date.required' => 'الرجاء إدخال تاريخ الإنجاز.',    'phases.*.completion_location.required' => 'الرجاء إدخال مكان الإنجاز.',    
	// Budget    
	'budget.*.total_cost.required' => 'الرجاء إدخال التكلفة الجملية.',   
	'budget.*.self_percent.required' => 'الرجاء إدخال النسبة المائوية.',    
	'budget.*.self_amount.required' => 'الرجاء إدخال المبلغ بالدينار.',   
	'budget.*.ministry_amount.required' => 'الرجاء إدخال المبلغ بالدينار.',
    'budget.*.ministry_percent.required' => 'الرجاء إدخال النسبة المائوية.', 
	'budget.*.supporters.*.name.required' => 'الرجاء إدخال اسم المساند.',    
	'budget.*.supporters.*.amount.required' => 'الرجاء إدخال مبلغ المساندة.',
    'budget.*.supporters.*.percent.required' => 'الرجاء إدخال النسبة المائوية.', 
	// Dépenses    
	'depenses.*.libelle_depense.required' => 'الرجاء إدخال اسم المصروف.', 
	'depenses.*.description.required' => 'الرجاء إدخال وصف المصروف.',   
	'depenses.*.cout.required' => 'الرجاء إدخال التكلفة.',    
	// Documents 
	'doc_fin.*.id_doc.required' => 'الرجاء اختيار نوع الوثيقة.',   
	'doc_fin.*.file.required' => 'الرجاء تحميل الوثيقة.',    ];
	}            
	$docRules = [];	
	if ($isBrouillon) {		
	foreach($request->doc_fin ?? [] as $i => $doc) {			
	$docRules["doc_fin.$i.file"] = 'nullable|file|mimes:pdf,jpg,jpeg,png,doc,docx|max:2048';		
	}	
	} else {		
	foreach($request->doc_fin ?? [] as $i => $doc) {			
	$rule = [];			
	if(!in_array($doc['id_doc'], [15,17])) {
		$rule[] = 'required';			
		}			$rule[] = 'file';		
		$rule[] = 'mimes:pdf,jpg,jpeg,png,doc,docx';	
		$rule[] = 'max:2048';			
		$docRules["doc_fin.$i.file"] = implode('|', $rule);	
		}	
		}   
		$rules = array_merge($rules, $docRules);     
		$request->validate($rules, $messages);         
		DB::beginTransaction();try {         
		$request->merge([                
		'types_financement' => $request->types_financement ?? [],    
		'phases' => $request->phases ?? [],             
		'budget' => $request->budget ?? [],               
		'depenses' => $request->depenses ?? [],            
		'doc_fin' => $request->doc_fin ?? [],         
		]);           
		$association = Association::create($request->only([  
		'nom_association','adresse','code_postal','tel','fax',   
		'date_creation','num_visa','date_visa','num_identification_fiscale',   
		'num_compte_courant','banque','adresse_mail','adresse_site_internet',   
		'nom_president_association','tel_personnel','num_membre_bureau_national_a',     
		'num_bureaux_regionaux','num_total_membre','id_formulaire'            
		]));            
		$demande = null;           
		if (!empty($request->types_financement)) {      
		foreach ($request->types_financement as $typeFinId) {      
		$demande = DemandeFinancement::create([                   
		'association_id'      => $association->id_association,      
		'type_financement_id' => $typeFinId,                     
		'type_formulaire_id'  => $request->id_formulaire,       
		'id_user'             => auth()->id(),                  
		]);               
		}           
		}           
		$superviseur = Superviseur::create($request->only([           
		'nom_prenom_sup','profession_sup','role_sup','tel_sup','email_sup'            
		]));          
		$projet = Projet::create([               
		'id_superviseur'          => $superviseur->id_sup,     
		'id_formulaire'           => $request->id_formulaire,     
		'id_demande'              => $demande?->id_demande_fin,   
		'id_user'                 => auth()->id(),               
		'nom_projet'              => $request->nom_projet,            
		'justification_realisation'=> $request->justification_realisation,    
		'objectives'              => $request->objectives,              
		'public'                  => $request->public,               
		'nombre_spectateur'       => $request->nombre_spectateur,      
		'tranch_age_min'          => $request->tranch_age_min,        
        'tranch_age_max'          => $request->tranch_age_max,            
		'parties_realisation'     => $request->parties_realisation,      
		'resultat_quantitatif'    => $request->resultat_quantitatif,     
		'resultat_qualitatif'     => $request->resultat_qualitatif,       
		'perspectives'            => $request->perspectives,           
		]);            
		foreach ($request->phases as $phase) {          
		if (!empty($phase['description'])) {                  
		ActivitePhase::create([                      
		'id_projet' => $projet->id_projet,           
		'description' => $phase['description'],      
		'completion_date' => $phase['completion_date'] ?? null,  
		'completion_location' => $phase['completion_location'] ?? null,  
		]);               
		}           
		}         
		$estimation = null;        
		foreach ($request->budget as $budget) {               
		$estimation = EstimationBudget::create([                   
		'projet_id'                     => $projet->id_projet,           
		'cout_total_estime'             => $budget['total_cost'] ?? 0,       
		'financement_propre_pourcentage'=> $budget['self_percent'] ?? 0,     
		'financement_propre_montant'    => $budget['self_amount'] ?? 0,      
		'aide_ministere_montant'        => $budget['ministry_amount'] ?? 0,   
		'aide_ministere_pourcentage'    => $budget['ministry_percent'] ?? 0,    
		]);                
		if (!empty($budget['supporters'])) {      
		foreach ($budget['supporters'] as $supporter) {  
		if (!empty($supporter['name'])) {                      
		ContributeurProjet::create([                         
		'id_estimation_budget' => $estimation->id_estimation,   
		'nom' => $supporter['name'],                            
		'montant' => $supporter['amount'] ?? 0,                 
		'pourcentage' => $supporter['percent'] ?? 0,            
		]);                       
		}                   
		}                
		}           
		}            
		foreach ($request->depenses as $depense) {   
		if (!empty($depense['libelle_depense'])) {     
		PosteDepense::create([                       
		'id_estimation_budget' => $estimation?->id_estimation,    
		'libelle_depense' => $depense['libelle_depense'],       
		'description' => $depense['description'] ?? '',            
		'cout' => $depense['cout'] ?? 0,                 
		]);               
		}            
		}           
		$docList = DocumentsFinancementList::create([  
		'id_projet'     => $projet->id_projet,         
		'id_formulaire' => $request->id_formulaire,       
		'id_statut1'    => $isBrouillon ? 6 : 2,           
		'id_statut2'    => null,              
		'id_user'       => auth()->id(),      
		'brouillon'     => $request->brouillon ? 1 : 0,    
        ]);            
		foreach ($request->doc_fin as $doc) {          
		if (!empty($doc['id_doc'])) {                
		$fileContent = null;                    if (isset($doc['file'])) {  
		$fileContent = file_get_contents($doc['file']->getRealPath());    
		}                    DocumentsFinancement::create([              
		'id_doc'      => $doc['id_doc'],                      
		'file'        => $fileContent,                
        'id_doc_list' => $docList->id_doc_list,      
		]);                }            }         
		DB::commit();           
		return redirect()->route('doc_fin.index')   
		->with('success', 'تم إنشاء النموذج بنجاح');   
		}        catch (\Exception $e) {          
		DB::rollBack();           
		return back()->withErrors(['error' => 'حدث خطأ أثناء الحفظ: ' . $e->getMessage()])                       
		->withInput();        }    }

    public function show($id)
    {
        $docList = DocumentsFinancementList::with([
            'projet.superviseur',
            'projet.activites',
            'projet.estimationBudget',
            'projet.estimationBudget.contributeurs',
            'projet.estimationBudget.postesDepense','documents',
            'documents.typeDocument',
            'statut1', 'statut2'
        ])->findOrFail($id);

        $formulaire = TypeFormulaire::find(6);
        $formulaire2 = TypeFormulaire::find(7);
        $formulaire3 = TypeFormulaire::find(8);
        $type_financement = TypeFinancement::all();

        $demande_id = $docList->projet->id_demande;
        $demande = DemandeFinancement::with('association')->find($demande_id);

        $selectedAssociationId = $demande && $demande->association 
            ? $demande->association->id_association 
            : null;

        $selectedAssociationName = $demande && $demande->association 
            ? $demande->association->nom_association 
            : null;

        $id_projet = $docList->projet->id_projet; 
        $documents = DocumentsFinancementList::where('id_projet', $id_projet)->get();
        $typedocum = TpTypeDocument::all();

        $selectedTypes = DemandeFinancement::where('association_id', $demande->association_id)
                                            ->pluck('type_financement_id')
                                            ->toArray();

        $documents = $docList->documents;

        return view('backoffice.financement.documents_financement.show', compact(
            'docList','formulaire','formulaire2','formulaire3','type_financement',
            'demande_id','demande','selectedAssociationId','selectedAssociationName','documents',
            'id_projet','typedocum','selectedTypes','docList'
        ));
    }

        public function brouillons_show($id)
    {
        $docList = DocumentsFinancementList::with([
            'projet.superviseur',
            'projet.activites',
            'projet.estimationBudget',
            'projet.estimationBudget.contributeurs',
            'projet.estimationBudget.postesDepense','documents',
            'documents.typeDocument',
            'statut1', 'statut2'
        ])->findOrFail($id);

        $formulaire = TypeFormulaire::find(6);
        $formulaire2 = TypeFormulaire::find(7);
        $formulaire3 = TypeFormulaire::find(8);
        $type_financement = TypeFinancement::all();

        $demande_id = $docList->projet->id_demande;
        $demande = DemandeFinancement::with('association')->find($demande_id);

        $selectedAssociationId = $demande && $demande->association 
            ? $demande->association->id_association 
            : null;

        $selectedAssociationName = $demande && $demande->association 
            ? $demande->association->nom_association 
            : null;

        $id_projet = $docList->projet->id_projet; 
        $documents = DocumentsFinancementList::where('id_projet', $id_projet)->get();
        $typedocum = TpTypeDocument::all();

        $selectedTypes = DemandeFinancement::where('association_id', $demande->association_id)
                                            ->pluck('type_financement_id')
                                            ->toArray();

        $documents = $docList->documents;

        return view('backoffice.financement.documents_financement.brouillons_show', compact(
            'docList','formulaire','formulaire2','formulaire3','type_financement',
            'demande_id','demande','selectedAssociationId','selectedAssociationName','documents',
            'id_projet','typedocum','selectedTypes','docList'
        ));
    }

    
    public function edit($id)
    {
        $docList = DocumentsFinancementList::with([
            'projet.superviseur',
            'projet.activites',
            'projet.estimationBudget',
            'projet.estimationBudget.contributeurs',
            'projet.estimationBudget.postesDepense','documents',
            'documents.typeDocument',
            'statut1', 'statut2'
        ])->findOrFail($id);

        $formulaire = TypeFormulaire::find(6);
        $formulaire2 = TypeFormulaire::find(7);
        $formulaire3 = TypeFormulaire::find(8);
        $type_financement = TypeFinancement::all();
        $demande_id = $docList->projet->id_demande;
        $demande = DemandeFinancement::with('association')->find($demande_id);

        $selectedAssociationId = $demande && $demande->association 
            ? $demande->association->id_association 
            : null;

        $selectedAssociationName = $demande && $demande->association 
            ? $demande->association->nom_association 
            : null;

        $id_projet = $docList->projet->id_projet; 
        $documents = DocumentsFinancementList::where('id_projet', $id_projet)->get();
        $typedocum = TpTypeDocument::all();

        $selectedTypes = DemandeFinancement::where('association_id', $demande->association_id)
                                            ->pluck('type_financement_id')
                                            ->toArray();

        $documents = $docList->documents;
 $statuts = TpStatut::orderBy('id_statut')->get();
        return view('backoffice.financement.documents_financement.edit', compact(
            'docList','formulaire','formulaire2','formulaire3','type_financement',
            'demande_id','demande','selectedAssociationId','selectedAssociationName','documents',
            'id_projet','typedocum','selectedTypes','docList','statuts'
        ));
    }


    public function brouillons_edit($id)
    {
        $docList = DocumentsFinancementList::with([
            'projet.superviseur',
            'projet.activites',
            'projet.estimationBudget',
            'projet.estimationBudget.contributeurs',
            'projet.estimationBudget.postesDepense','documents',
            'documents.typeDocument',
            'statut1', 'statut2'
        ])->findOrFail($id);

        $formulaire = TypeFormulaire::find(6);
        $formulaire2 = TypeFormulaire::find(7);
        $formulaire3 = TypeFormulaire::find(8);
        $type_financement = TypeFinancement::all();

        $demande_id = $docList->projet->id_demande;
        $demande = DemandeFinancement::with('association')->find($demande_id);

        $selectedAssociationId = $demande && $demande->association 
            ? $demande->association->id_association 
            : null;

        $selectedAssociationName = $demande && $demande->association 
            ? $demande->association->nom_association 
            : null;

        $id_projet = $docList->projet->id_projet; 
        $documents = DocumentsFinancementList::where('id_projet', $id_projet)->get();
        $typedocum = TpTypeDocument::all();

        $selectedTypes = DemandeFinancement::where('association_id', $demande->association_id)
                                            ->pluck('type_financement_id')
                                            ->toArray();

        $documents = $docList->documents;

        return view('backoffice.financement.documents_financement.brouillons_edit', compact(
            'docList','formulaire','formulaire2','formulaire3','type_financement',
            'demande_id','demande','selectedAssociationId','selectedAssociationName','documents',
            'id_projet','typedocum','selectedTypes','docList'
        ));
    }


    /*public function update(Request $request, $id)
    {
        DB::beginTransaction();

        try {
            $rules = [
                
                    // Association
                    'nom_association' => 'required|string|max:255',
                    'adresse' => 'required|string|max:255',
                    'code_postal' => 'required|string|max:20',
                    'tel' => 'required|string|max:50',
                    'fax' => 'required|string|max:50',
                    'date_creation' => 'required|date',
                    'num_visa' => 'required|string|max:100',
                    'date_visa' => 'required|date',
                    'num_identification_fiscale' => 'required|string|max:100',
                    'num_compte_courant' => 'required|string|max:100',
                    'banque' => 'required|string|max:255',
                    'adresse_mail' => 'required|email|max:255',
                    'adresse_site_internet' => 'required|string|max:255',
                    'nom_president_association' => 'required|string|max:255',
                    'tel_personnel' => 'required|string|max:50',
                    'num_membre_bureau_national_a' => 'required|integer',
                    'num_bureaux_regionaux' => 'required|integer',
                    'num_total_membre' => 'required|integer',
                    'types_financement' => 'required|array|min:1',
                    'id_formulaire' => 'required|integer|exists:tp_type_formulaire,id_type',

                    // Superviseur
                    'nom_prenom_sup' => 'required|string|max:100',
                    'profession_sup' => 'required|string|max:100',
                    'role_sup'       => 'required|string|max:100',
                    'tel_sup'        => 'required|string|max:12',
                    'email_sup'      => 'required|email|max:255',

                    // Projet
                    'nom_projet'               => 'required|string|max:255',
                    'justification_realisation'=> 'required|string|max:255',
                    'objectives'               => 'required|string',
                    'public'                   => 'required|string|max:255',
                    'nombre_spectateur'        => 'required|integer|min:1',
                    'tranch_age_min'           => 'required|integer|min:0',
                    'tranch_age_max'           => 'required|integer|gte:tranch_age_min',
                    'parties_realisation'      => 'required|string',
                    'resultat_quantitatif'     => 'required|string',
                    'resultat_qualitatif'      => 'required|string',
                    'perspectives'             => 'required|string',

                    // Phases
                    'phases.*.description'         => 'required|string|max:200',
                    'phases.*.completion_date'     => 'required|date',
                    'phases.*.completion_location' => 'required|string|max:100',

                    // Budget
                    'budget.*.total_cost'      => 'required|numeric|min:0',
                    'budget.*.self_percent'    => 'required|numeric|min:0|max:100',
                    'budget.*.self_amount'     => 'required|numeric|min:0',
                    'budget.*.ministry_amount' => 'required|numeric|min:0',
                    'budget.*.ministry_percent'=> 'required|numeric|min:0|max:100',
                    'budget.*.supporters.*.name'   => 'required|string|max:255',
                    'budget.*.supporters.*.amount' => 'required|numeric|min:0',
                    'budget.*.supporters.*.percent'=> 'required|numeric|min:0|max:100',

                    // Dépenses
                    

                    'depenses.*.*.libelle_depense' => 'required|string|max:200',
                    'depenses.*.*.description'     => 'required|string|max:255',
                    'depenses.*.*.cout'            => 'required|numeric|min:0',
                    // Documents
                    'doc_fin.*.id_doc' => 'required|integer|exists:tp_type_document,id_type_doc',
                    'doc_fin.*.file' => 'nullable|file|mimes:pdf,jpg,jpeg,png,doc,docx|max:2048',
                    'doc_fin.*.remarques' => 'nullable|string|max:100',
            ];

            $request->validate($rules);

            $docList = DocumentsFinancementList::findOrFail($id);
            $projet = $docList->projet;
            $association = $projet->association;
            $superviseur = $projet->superviseur;

            $association->update($request->only([
                'nom_association','adresse','code_postal','tel','fax',
                'date_creation','num_visa','date_visa','num_identification_fiscale',
                'num_compte_courant','banque','adresse_mail','adresse_site_internet',
                'nom_president_association','tel_personnel','num_membre_bureau_national_a',
                'num_bureaux_regionaux','num_total_membre','id_formulaire'
            ]));

            $superviseur->update($request->only([
                'nom_prenom_sup','profession_sup','role_sup','tel_sup','email_sup'
            ]));

            $projet->update([
                'id_formulaire'           => $request->id_formulaire,
                'nom_projet'              => $request->nom_projet,
                'justification_realisation'=> $request->justification_realisation,
                'objectives'              => $request->objectives,
                'public'                  => $request->public,
                'id_user' => auth()->id(),
                'nombre_spectateur'       => $request->nombre_spectateur,
                'tranch_age_min'          => $request->tranch_age_min,
                'tranch_age_max'          => $request->tranch_age_max,
                'parties_realisation'     => $request->parties_realisation,
                'resultat_quantitatif'    => $request->resultat_quantitatif,
                'resultat_qualitatif'     => $request->resultat_qualitatif,
                'perspectives'            => $request->perspectives,
            ]);

            $projet->activites()->delete();
            if ($request->has('phases')) {
                foreach ($request->phases as $phase) {
                    if (!empty($phase['description'])) {
                        ActivitePhase::create([
                            'id_projet'           => $projet->id_projet,
                            'description'         => $phase['description'],
                            'completion_date'     => $phase['completion_date'] ?? null,
                            'completion_location' => $phase['completion_location'] ?? null,
                        ]);
                    }
                }
            }

            if ($projet->estimationBudget && $projet->estimationBudget->count() > 0) {
                foreach ($projet->estimationBudget as $estimation) {
                    $estimation->contributeurs()->delete();
                    $estimation->postesDepense()->delete();
                    $estimation->delete();
                }
            }

            if ($request->has('budget')) {
                foreach ($request->budget as $budget) {
                    $estimation = EstimationBudget::create([
                        'projet_id'                      => $projet->id_projet,
                        'cout_total_estime'              => $budget['total_cost'] ?? 0,
                        'financement_propre_pourcentage' => $budget['self_percent'] ?? 0,
                        'financement_propre_montant'     => $budget['self_amount'] ?? 0,
                        'aide_ministere_montant'         => $budget['ministry_amount'] ?? 0,
                        'aide_ministere_pourcentage'     => $budget['ministry_percent'] ?? 0,
                    ]);

                    if (isset($budget['supporters'])) {
                        foreach ($budget['supporters'] as $supporter) {
                            if (!empty($supporter['name'])) {
                                $contributeurs = ContributeurProjet::create([
                                    'id_estimation_budget' => $estimation->id_estimation,
                                    'nom'        => $supporter['name'],
                                    'montant'    => $supporter['amount'] ?? 0,
                                    'pourcentage'=> $supporter['percent'] ?? 0,
                                ]);
                            }
                        }
                    }

                    if ($request->has('depenses')) {
                        foreach ($request->depenses as $depense) {
                            if (!empty($depense['libelle_depense'])) {
                                PosteDepense::create([
                                    'id_estimation_budget' => $estimation->id_estimation,
                                    'libelle_depense'      => $depense['libelle_depense'],
                                    'description'          => $depense['description'] ?? '',
                                    'cout'                 => $depense['cout'] ?? 0,
                                ]);
                            }
                        }
                    }
                }
            }

            if ($request->has('doc_fin')) {
                foreach ($request->doc_fin as $docData) {
                    $doc = isset($docData['id_doc']) 
                        ? DocumentsFinancement::where('id_doc_list', $docList->id_doc_list)
                                            ->where('id_doc', $docData['id_doc'])
                                            ->first() 
                        : new DocumentsFinancement();

                    if (isset($docData['file'])) {
                        $filePath = $docData['file']->store('documents_financement', 'public');
                        $doc->file = $filePath;
                    }

                    $doc->id_doc = $docData['id_doc'];
                    $doc->remarques = $docData['remarques'] ?? null;
                    $doc->id_doc_list = $docList->id_doc_list;
                    $doc->save();
                }
            }

            DB::commit();

            return redirect()->route('doc_fin.index', $docList->id_doc_list)
                ->with('success', 'تم تحديث الوثيقة بنجاح');
        } catch (\Exception $e) {
            DB::rollBack();
            return back()->withErrors(['error' => 'خطأ أثناء التحديث: ' . $e->getMessage()]);
        }
    }*/		
public function update(Request $request, $id)
{
    $isBrouillon = $request->brouillon == 1;
    
    if ($isBrouillon) {
        $rules = [
            'nom_association' => 'required|string|max:255',
            'types_financement' => 'required|array|min:1',
        ];
        $messages = [
            'nom_association.required' => 'الرجاء إدخال اسم الجمعية.',
            'types_financement.required' => 'الرجاء اختيار نوع التمويل.',
        ];
    } else {
        $rules = [
            // Association
            'nom_association' => 'required|string|max:255',
            'adresse' => 'required|string|max:255',
            'code_postal' => 'required|string|max:20',
            'tel' => 'required|string|max:50',
            'fax' => 'required|string|max:50',
            'date_creation' => 'required|date',
            'num_visa' => 'required|string|max:100',
            'date_visa' => 'required|date',
            'num_identification_fiscale' => 'required|string|max:100',
            'num_compte_courant' => 'required|string|max:100',
            'banque' => 'required|string|max:255',
            'adresse_mail' => 'required|email|max:255',
            'adresse_site_internet' => 'required|string|max:255',
            'nom_president_association' => 'required|string|max:255',
            'tel_personnel' => 'required|string|max:50',
            'num_membre_bureau_national_a' => 'required|integer',
            'num_bureaux_regionaux' => 'required|integer',
            'num_total_membre' => 'required|integer',
            'types_financement' => 'required|array|min:1',
            'id_formulaire' => 'required|integer|exists:tp_type_formulaire,id_type',

            // Superviseur
            'nom_prenom_sup' => 'required|string|max:100',
            'profession_sup' => 'required|string|max:100',
            'role_sup' => 'required|string|max:100',
            'tel_sup' => 'required|string|max:12',
            'email_sup' => 'required|email|max:255',

            // Projet
            'nom_projet' => 'required|string|max:255',
            'justification_realisation' => 'required|string|max:255',
            'objectives' => 'required|string',
            'public' => 'required|string|max:255',
            'nombre_spectateur' => 'required|integer|min:1',
            'tranch_age_min' => 'required|integer|min:0',
            'tranch_age_max' => 'required|integer|gte:tranch_age_min',
            'parties_realisation' => 'required|string',
            'resultat_quantitatif' => 'required|string',
            'resultat_qualitatif' => 'required|string',
            'perspectives' => 'required|string',

            // Phases
            'phases.*.description' => 'required|string|max:200',
            'phases.*.completion_date' => 'required|date',
            'phases.*.completion_location' => 'required|string|max:100',

            // Budget
            'budget.*.total_cost' => 'required|numeric|min:0',
            'budget.*.self_percent' => 'required|numeric|min:0|max:100',
            'budget.*.self_amount' => 'required|numeric|min:0',
            'budget.*.ministry_amount' => 'required|numeric|min:0',
            'budget.*.ministry_percent' => 'required|numeric|min:0|max:100',
            'budget.*.supporters.*.name' => 'required|string|max:255',
            'budget.*.supporters.*.amount' => 'required|numeric|min:0',
            'budget.*.supporters.*.percent' => 'required|numeric|min:0|max:100',

            // Dépenses
            'budget.*.depenses.*.libelle_depense' => 'required|string|max:200',
            'budget.*.depenses.*.description' => 'required|string|max:255',
            'budget.*.depenses.*.cout' => 'required|numeric|min:0',

            // Documents
            'doc_fin.*.id_doc' => 'required|integer|exists:tp_type_document,id_type_doc',
            'doc_fin.*.file' => 'required|file|mimes:pdf,jpg,jpeg,png,doc,docx|max:20480',
        ];
        
        $messages = [
            // Association
            'nom_association.required' => 'الرجاء إدخال اسم الجمعية.',
            'adresse.required' => 'الرجاء إدخال العنوان.',
            'code_postal.required' => 'الرجاء إدخال الرمز البريدي.',
            'tel.required' => 'الرجاء إدخال رقم الهاتف.',
            'fax.required' => 'الرجاء إدخال رقم الفاكس.',
            'date_creation.required' => 'الرجاء إدخال تاريخ التأسيس.',
            'parties_realisation' => 'الرجاء إدخال الأطراف المشاركة في الإنجاز.',
            'resultat_quantitatif' => 'الرجاء إدخال  النتائج الكمية.',
            'resultat_qualitatif' => 'الرجاء إدخال  النتائج النوعية.',
            'perspectives' => 'الرجاء إدخال الآفاق المنتظرة.',
            'num_visa.required' => 'الرجاء إدخال رقم التأشيرة.',
            'date_visa.required' => 'الرجاء إدخال تاريخ التأشيرة.',
            'num_identification_fiscale.required' => 'الرجاء إدخال المعرف الجبائي.',
            'num_compte_courant.required' => 'الرجاء إدخال رقم الحساب الجاري.',
            'banque.required' => 'الرجاء إدخال اسم البنك.',
            'adresse_mail.required' => 'الرجاء إدخال البريد الإلكتروني.',
            'adresse_site_internet.required' => 'الرجاء إدخال الموقع الإلكتروني.',
            'nom_president_association.required' => 'الرجاء إدخال اسم رئيس الجمعية.',
            'tel_personnel.required' => 'الرجاء إدخال الهاتف الشخصي.',
            'num_membre_bureau_national_a.required' => 'الرجاء إدخال عدد أعضاء المكتب الوطني.',
            'num_bureaux_regionaux.required' => 'الرجاء إدخال عدد المكاتب الجهوية.',
            'num_total_membre.required' => 'الرجاء إدخال العدد الجملي للأعضاء.',
            'types_financement.required' => 'الرجاء اختيار نوع التمويل.',
            'id_formulaire.required' => 'الرجاء اختيار نوع الاستمارة.',
            
            // Superviseur
            'nom_prenom_sup.required' => 'الرجاء إدخال اسم المشرف.',
            'profession_sup.required' => 'الرجاء إدخال مهنة المشرف.',
            'role_sup.required' => 'الرجاء إدخال دور المشرف.',
            'tel_sup.required' => 'الرجاء إدخال رقم هاتف المشرف.',
            'email_sup.required' => 'الرجاء إدخال بريد المشرف.',
            
            // Projet
            'nom_projet.required' => 'الرجاء إدخال اسم المشروع.',
            'justification_realisation.required' => 'الرجاء إدخال مبررات الإنجاز.',
            'objectives.required' => 'الرجاء إدخال الأهداف.',
            'public.required' => 'الرجاء إدخال الفئة المستهدفة.',
            'nombre_spectateur.required' => 'الرجاء إدخال عدد المتفرجين.',
            'tranch_age_min.required' => 'الرجاء إدخال الحد الأدنى للعمر.',
            'tranch_age_max.required' => 'الرجاء إدخال الحد الأقصى للعمر.',
            'tranch_age_max.gte' => 'يجب أن يكون الحد الأقصى للعمر أكبر من الحد الأدنى.',
            
            // Phases
            'phases.*.description.required' => 'الرجاء إدخال وصف المرحلة.',
            'phases.*.completion_date.required' => 'الرجاء إدخال تاريخ الإنجاز.',
            'phases.*.completion_location.required' => 'الرجاء إدخال مكان الإنجاز.',
            
            // Budget
            'budget.*.total_cost.required' => 'الرجاء إدخال التكلفة الجملية التقديرية.',
            'budget.*.self_percent.required' => 'الرجاء إدخال النسبة المائوية للتمويل الذاتي.',
            'budget.*.self_amount.required' => 'الرجاء إدخال مبلغ التمويل الذاتي.',
            'budget.*.ministry_amount.required' => 'الرجاء إدخال مبلغ الدعم المطلوب من الوزارة.',
            'budget.*.ministry_percent.required' => 'الرجاء إدخال النسبة المائوية للدعم.',
            'budget.*.supporters.*.name.required' => 'الرجاء إدخال اسم المساند.',
            'budget.*.supporters.*.amount.required' => 'الرجاء إدخال مبلغ المساندة.',
            'budget.*.supporters.*.percent.required' => 'الرجاء إدخال النسبة المائوية.',
            
            // Dépenses
            'budget.*.depenses.*.libelle_depense.required' => 'الرجاء إدخال اسم المصروف.',
            'budget.*.depenses.*.description.required' => 'الرجاء إدخال وصف المصروف.',
            'budget.*.depenses.*.cout.required' => 'الرجاء إدخال التكلفة.',
            
            // Documents
            'doc_fin.*.id_doc.required' => 'الرجاء اختيار نوع الوثيقة.',
            'doc_fin.*.file.required' => 'الرجاء تحميل الوثيقة.',
        ];
    }
    
    $docRules = [];
    foreach ($request->doc_fin ?? [] as $i => $doc) {
        // Est-ce que le document existe déjà dans la base ?
        $existing = DocumentsFinancement::where('id_doc_list', $id)
                        ->where('id_doc', $doc['id_doc'])
                        ->exists();
        
        $rule = [];
        // Document est obligatoire SEULEMENT si pas déjà existant
        if (!$existing) {
            $rule[] = 'required';
        } else {
            $rule[] = 'nullable';
        }
        // Si fourni, on valide le type
        $rule[] = 'file';
        $rule[] = 'mimes:pdf,jpg,jpeg,png,doc,docx';
        $rule[] = 'max:20480';
        
        $docRules["doc_fin.$i.file"] = implode('|', $rule);
    }
    
    $rules = array_merge($rules, $docRules);
    
    $request->validate($rules, $messages);
    
    DB::beginTransaction();
    
    try {
        $docList = DocumentsFinancementList::findOrFail($id);
        $projet = $docList->projet;
        
        if (!$projet) {
            Log::error("DocumentsFinancementList #{$id} has no related project.", ['docList_id' => $id]);
            return back()->withErrors(['error' => 'المشروع المرتبط بالقائمة غير موجود. الرجاء التحقق.'])->withInput();
        }
        
        $assocData = $request->only([
            'nom_association','adresse','code_postal','tel','fax',
            'date_creation','num_visa','date_visa','num_identification_fiscale',
            'num_compte_courant','banque','adresse_mail','adresse_site_internet',
            'nom_president_association','tel_personnel','num_membre_bureau_national_a',
            'num_bureaux_regionaux','num_total_membre','id_formulaire'
        ]);
        
        $association = $projet->association;
        if ($association) {
            $association->update($assocData);
        } else {
            if (method_exists($projet, 'association')) {
                $association = $projet->association()->create($assocData);
                Log::info("Created association for project", ['project_id' => $projet->id_projet, 'association_id' => $association->id ?? null]);
            } else {
                Log::warning("Project has no 'association' relation method; cannot create association.", ['project_id' => $projet->id_projet]);
            }
        }
        
        $superviseur = $projet->superviseur;
        if ($association) {
            $association->update($request->only([
                'nom_association','adresse','code_postal','tel','fax',
                'date_creation','num_visa','date_visa','num_identification_fiscale',
                'num_compte_courant','banque','adresse_mail','adresse_site_internet',
                'nom_president_association','tel_personnel','num_membre_bureau_national_a',
                'num_bureaux_regionaux','num_total_membre','id_formulaire'
            ]));
        }
        
        if ($superviseur) {
            $superviseur->update($request->only([
                'nom_prenom_sup','profession_sup','role_sup','tel_sup','email_sup'
            ]));
        }
        
        $projet->update([
            'id_formulaire' => $request->id_formulaire,
            'nom_projet' => $request->nom_projet,
            'justification_realisation' => $request->justification_realisation,
            'objectives' => $request->objectives,
            'public' => $request->public,
            'id_user' => auth()->id(),
            'nombre_spectateur' => $request->nombre_spectateur,
            'tranch_age_min' => $request->tranch_age_min,
            'tranch_age_max' => $request->tranch_age_max,
            'parties_realisation' => $request->parties_realisation,
            'resultat_quantitatif' => $request->resultat_quantitatif,
            'resultat_qualitatif' => $request->resultat_qualitatif,
            'perspectives' => $request->perspectives,
        ]);
        
        // Phases: wipe and recreate
        $projet->activites()->delete();
        if ($request->has('phases')) {
            foreach ($request->phases as $phase) {
                if (!empty($phase['description'])) {
                    ActivitePhase::create([
                        'id_projet' => $projet->id_projet,
                        'description' => $phase['description'],
                        'completion_date' => $phase['completion_date'] ?? null,
                        'completion_location' => $phase['completion_location'] ?? null,
                    ]);
                }
            }
        }
        
        // Remove existing budgets and related rows
        if ($projet->estimationBudget && $projet->estimationBudget->count() > 0) {
            foreach ($projet->estimationBudget as $estimation) {
                $estimation->contributeurs()->delete();
                $estimation->postesDepense()->delete();
                $estimation->delete();
            }
        }
        
        // Recreate budgets from request
        if ($request->has('budget')) {
            foreach ($request->budget as $budget) {
                $estimation = EstimationBudget::create([
                    'projet_id' => $projet->id_projet,
                    'cout_total_estime' => $budget['total_cost'] ?? 0,
                    'financement_propre_pourcentage' => $budget['self_percent'] ?? 0,
                    'financement_propre_montant' => $budget['self_amount'] ?? 0,
                    'aide_ministere_montant' => $budget['ministry_amount'] ?? 0,
                    'aide_ministere_pourcentage' => $budget['ministry_percent'] ?? 0,
                ]);
                
                if (isset($budget['supporters'])) {
                    foreach ($budget['supporters'] as $supporter) {
                        if (!empty($supporter['name'])) {
                            ContributeurProjet::create([
                                'id_estimation_budget' => $estimation->id_estimation,
                                'nom' => $supporter['name'],
                                'montant' => $supporter['amount'] ?? 0,
                                'pourcentage' => $supporter['percent'] ?? 0,
                            ]);
                        }
                    }
                }
                
                if ($request->has('depenses')) {
                    foreach ($request->depenses as $budgetDepenses) {
                        foreach ($budgetDepenses as $depense) {
                            if (!empty($depense['libelle_depense'])) {
                                PosteDepense::create([
                                    'id_estimation_budget' => $estimation->id_estimation,
                                    'libelle_depense' => $depense['libelle_depense'],
                                    'description' => $depense['description'] ?? '',
                                    'cout' => $depense['cout'] ?? 0,
                                ]);
                            }
                        }
                    }
                }
            }
        }
        
        // MODIFICATION: GESTION DES FICHIERS DANS LE DOSSIER EXTERNE
        $uploadDir = '/home/preprov/www/mjs/shared_uploads/images';
        
        // Vérifier si le dossier existe, sinon le créer
        if (!is_dir($uploadDir)) {
            if (!mkdir($uploadDir, 0755, true)) {
                DB::rollBack();
                abort(500, 'Impossible de créer le dossier upload');
            }
        }
        
        // Vérifier les permissions d'écriture
        if (!is_writable($uploadDir)) {
            DB::rollBack();
            abort(500, 'Dossier upload non accessible en écriture');
        }
        
        if ($request->has('doc_fin')) {
            foreach ($request->doc_fin as $docData) {
                // Chercher le document existant
                $doc = DocumentsFinancement::where('id_doc_list', $docList->id_doc_list)
                                          ->where('id_doc', $docData['id_doc'])
                                          ->first();
                
                // Si le document n'existe pas, en créer un nouveau
                if (!$doc) {
                    $doc = new DocumentsFinancement();
                    $doc->id_doc = $docData['id_doc'];
                    $doc->id_doc_list = $docList->id_doc_list;
                }
                
                // Si un nouveau fichier est fourni
                if (!empty($docData['file']) && $docData['file'] instanceof \Illuminate\Http\UploadedFile) {
                    $file = $docData['file'];
                    
                    // Supprimer l'ancien fichier s'il existe (si c'est un chemin)
                    if ($doc->file && is_string($doc->file) && file_exists($doc->file)) {
                        @unlink($doc->file);
                    }
                    
                    // Récupérer les informations du fichier
                    $originalName = $file->getClientOriginalName();
                    $extension = $file->getClientOriginalExtension();
                    
                    // Nom sécurisé
                    $original = pathinfo($originalName, PATHINFO_FILENAME);
                    $safe = Str::slug(mb_substr($original, 0, 40));
                    if ($safe === '') {
                        $safe = 'document';
                    }
                    
                    // Nom unique avec timestamp et random
                    $filename = $safe . '-' . time() . '-' . rand(1000, 9999) . '.' . $extension;
                    $targetPath = $uploadDir . DIRECTORY_SEPARATOR . $filename;
                    
                    // Déplacer le fichier
                    try {
                        $file->move($uploadDir, $filename);
                    } catch (\Exception $e) {
                        DB::rollBack();
                        abort(500, 'Erreur lors du déplacement du fichier: ' . $e->getMessage());
                    }
                    
                    // Vérifier que le fichier a bien été créé
                    if (!file_exists($targetPath)) {
                        DB::rollBack();
                        abort(500, 'Fichier non créé après déplacement');
                    }
                    
                    // Mettre à jour le champ file (chemin du fichier)
                    $doc->file = $targetPath;
                } else {
                    // Si pas de nouveau fichier mais brouillon, garder l'ancien
                    // ou mettre à null si pas de fichier existant
                    if ($isBrouillon && !$doc->file) {
                        $doc->file = null;
                    }
                }
                
                $doc->save();
            }
        }
        
        $oldStat1 = (int) ($docList->getOriginal('id_statut1') ?? 0);
        $oldStat2 = (int) ($docList->getOriginal('id_statut2') ?? 0);
        $oldDecision = $docList->getOriginal('decision_finale');
        
        $newStat1 = (int) $request->input('id_statut1', $docList->id_statut1 ?? 0);
        
        $newStat2 = $request->has('id_statut2')
            ? (int) $request->input('id_statut2')
            : (int) $docList->id_statut2;
        
        if ($newStat1 === 1) {
            $newStat2 = 2;
        }
        
        // MODIFICATION: GESTION DU FICHIER decision_finale DANS LE DOSSIER EXTERNE
        $newDecision = null;
        if ($request->hasFile('decision_finale')) {
            $decisionFile = $request->file('decision_finale');
            
            // Supprimer l'ancien fichier decision_finale s'il existe (si c'est un chemin)
            if ($docList->decision_finale && is_string($docList->decision_finale) && file_exists($docList->decision_finale)) {
                @unlink($docList->decision_finale);
            }
            
            // Récupérer les informations du fichier
            $originalName = $decisionFile->getClientOriginalName();
            $extension = $decisionFile->getClientOriginalExtension();
            
            // Nom sécurisé
            $original = pathinfo($originalName, PATHINFO_FILENAME);
            $safe = Str::slug(mb_substr($original, 0, 40));
            if ($safe === '') {
                $safe = 'decision';
            }
            
            // Nom unique avec timestamp et random
            $filename = $safe . '-decision-' . time() . '-' . rand(1000, 9999) . '.' . $extension;
            $targetPath = $uploadDir . DIRECTORY_SEPARATOR . $filename;
            
            // Déplacer le fichier
            try {
                $decisionFile->move($uploadDir, $filename);
            } catch (\Exception $e) {
                DB::rollBack();
                abort(500, 'Erreur lors du déplacement du fichier decision_finale: ' . $e->getMessage());
            }
            
            // Vérifier que le fichier a bien été créé
            if (!file_exists($targetPath)) {
                DB::rollBack();
                abort(500, 'Fichier decision_finale non créé après déplacement');
            }
            
            $newDecision = $targetPath;
        } else {
            // Si aucun nouveau fichier n'est fourni, garder l'ancienne décision
            $newDecision = $docList->decision_finale;
        }
        
        // Prepare comment selection (prefer dedicated fields, then fallback to commentaire_motif)
        $comment = null;
        if ($request->filled('commentaire_refus')) {
            $comment = trim($request->input('commentaire_refus'));
        } elseif ($request->filled('commentaire_status')) {
            $comment = trim($request->input('commentaire_status'));
        } elseif ($request->filled('commentaire_motif')) {
            $comment = trim($request->input('commentaire_motif'));
        }
        if ($comment === '') $comment = null;
        
        $commentDecision = $request->input('commentaire_motif1') ?? $request->input('commentaire_motif2') ?? null;
        
        // create history records when changed
        if ($oldStat1 !== $newStat1) {
            ImmobilierStatutHistory::create([
                'documents_financement_list_id' => $docList->id_doc_list,
                'projet_id' => $docList->id_projet,
                'from_statut_id' => $oldStat1 ?: null,
                'to_statut_id' => $newStat1,
                'changed_by' => Auth::id() ?? null,
                'commentaire' => $comment,
            ]);
        }
        
        if ($oldStat2 !== $newStat2) {
            ImmobilierStatutHistory::create([
                'documents_financement_list_id' => $docList->id_doc_list,
                'projet_id' => $docList->id_projet,
                'from_statut_id' => $oldStat2 ?: null,
                'to_statut_id' => $newStat2,
                'changed_by' => Auth::id() ?? null,
                'commentaire' => $comment,
            ]);
        }
        
        // persist new status values to the list
        $docList->update([
            'id_statut1' => $newStat1,
            'id_statut2' => $newStat2,
            'decision_finale' => $newDecision,
            // optionally: 'commentaire_motif1' => $comment1, 'commentaire_motif2' => $comment2
        ]);
        
        DB::commit();
        
        // Notifications + Emails
        try {
            $recipient = $docList->user ?? ($docList->projet->user ?? null);
            $email = null;
            if ($recipient) {
                $email = $recipient->email ?? $recipient->adresse_mail ?? null;
            }
            
            $statusMap = [
                1 => 'accepted',
                3 => 'rejected',
                4 => 'incomplete',
                5 => 'deferred',
            ];
            
            $buildParams = function(int $statut, ?string $comment) {
                $params = [];
                if ($statut === 3) $params['reason'] = $comment ?? '';
                if ($statut === 4) $params['missing'] = $comment ?? '';
                if ($statut === 5) $params['note'] = $comment ?? '';
                if ($statut === 1) $params['date'] = now()->format('Y-m-d');
                if (!empty($comment)) $params['comment'] = $comment;
                return $params;
            };
            
            // statut1 change
            if ($oldStat1 !== $newStat1) {
                $type1 = $statusMap[$newStat1] ?? 'status_changed';
                $params1 = $buildParams($newStat1, $comment);
                
                if ($recipient) {
                    $recipient->notify(new \App\Notifications\StatutDocumentNotification(
                        $docList,
                        $type1,
                        $params1,
                        $docList->id_doc_list
                    ));
                }
                
                if ($email) {
                    Mail::to($email)->send(new StatutDocumentChanged($docList, $type1, $params1, $recipient));
                }
            }
            
            // statut2 change
            if ($oldStat2 !== $newStat2) {
                $type2 = $statusMap[$newStat2] ?? 'status_changed';
                $params2 = $buildParams($newStat2, $comment);
                
                if ($recipient) {
                    $recipient->notify(new \App\Notifications\StatutDocumentNotification(
                        $docList,
                        $type2,
                        $params2,
                        $docList->id_doc_list
                    ));
                }
                
                if ($email) {
                    Mail::to($email)->send(new StatutDocumentChanged($docList, $type2, $params2, $recipient));
                }
            }
            
            // final decision change
            if ($oldDecision !== $newDecision) {
                $decType = 'status_changed';
                $decParams = ['note' => $commentDecision ?? $comment ?? ''];
                if ($recipient) {
                    $recipient->notify(new \App\Notifications\StatutDocumentNotification(
                        $docList,
                        $decType,
                        $decParams,
                        $docList->id_doc_list
                    ));
                }
                if ($email) {
                    Mail::to($email)->send(new StatutDocumentChanged($docList, $decType, $decParams, $recipient));
                }
            }
        } catch (\Exception $ex) {
            \Log::error("Notification/email error for DocumentsFinancementList ID {$docList->id_doc_list}: " . $ex->getMessage(), [
                'trace' => $ex->getTraceAsString()
            ]);
        }
        
        return redirect()->route('doc_fin.index', $docList->id_doc_list)
            ->with('success', 'تم تحديث الوثيقة بنجاح');
            
    } catch (\Exception $e) {
        DB::rollBack();
        return back()->withErrors(['error' => 'خطأ أثناء التحديث: ' . $e->getMessage()]);
    }
}

public function showFile($id)
{
    $doc = DocumentsFinancement::findOrFail($id);
    
    if (!$doc->file) {
        abort(404, 'Aucun fichier.');
    }
    
    // Si c'est un chemin (nouveau système), lire le fichier depuis le disque
    if (is_string($doc->file) && file_exists($doc->file)) {
        // Vérifier si le fichier existe physiquement
        if (!file_exists($doc->file)) {
            abort(404, 'Fichier introuvable sur le disque.');
        }
        
        // Déterminer le type MIME à partir du fichier
        $mimeType = mime_content_type($doc->file);
        
        // Lire le contenu du fichier
        $content = file_get_contents($doc->file);
        
        return response($content)
            ->header('Content-Type', $mimeType)
            ->header('Content-Disposition', 'inline; filename="' . basename($doc->file) . '"');
    } 
    // Si c'est un BLOB (ancien système - rétrocompatibilité)
    else {
        // Detecter automatiquement le type MIME
        $finfo = finfo_open();
        $mimeType = finfo_buffer($finfo, $doc->file, FILEINFO_MIME_TYPE);
        finfo_close($finfo);
        
        return response($doc->file)
            ->header('Content-Type', $mimeType);
    }
}

public function showDecision($id)
{
    $doc = DocumentsFinancementList::findOrFail($id);
    
    if (empty($doc->decision_finale)) {
        abort(404);
    }
    
    // Si c'est un chemin (nouveau système), lire le fichier depuis le disque
    if (is_string($doc->decision_finale) && file_exists($doc->decision_finale)) {
        // Vérifier si le fichier existe physiquement
        if (!file_exists($doc->decision_finale)) {
            abort(404, 'Fichier decision_finale introuvable sur le disque.');
        }
        
        // Déterminer le type MIME à partir du fichier
        $mimeType = mime_content_type($doc->decision_finale);
        
        // Lire le contenu du fichier
        $content = file_get_contents($doc->decision_finale);
        
        return response($content)
            ->header('Content-Type', $mimeType)
            ->header('Content-Disposition', 'inline; filename="' . basename($doc->decision_finale) . '"');
    } 
    // Si c'est un BLOB (ancien système - rétrocompatibilité)
    else {
        $finfo = new \finfo(FILEINFO_MIME_TYPE);
        $mimeType = $finfo->buffer($doc->decision_finale);
        
        return response($doc->decision_finale, 200)
            ->header('Content-Type', $mimeType)
            ->header('Content-Disposition', 'inline');
    }
}





    
    public function brouillons_update(Request $request, $id)
{
    DB::beginTransaction();

    try {
        $isBrouillon = $request->brouillon == 1; // Détermine si on sauvegarde comme brouillon

        // Validation conditionnelle
        if ($isBrouillon) {
            // Seulement le nom de l'association est obligatoire pour le brouillon
            $rules = [
                'nom_association' => 'required|string|max:255',
            ];
        } else {
            // Validation complète pour le bouton "Envoyer"
            $rules = [
                // Association
                'nom_association' => 'required|string|max:255',
                'adresse' => 'required|string|max:255',
                'code_postal' => 'required|string|max:20',
                'tel' => 'required|string|max:50',
                'fax' => 'required|string|max:50',
                'date_creation' => 'required|date',
                'num_visa' => 'required|string|max:100',
                'date_visa' => 'required|date',
                'num_identification_fiscale' => 'required|string|max:100',
                'num_compte_courant' => 'required|string|max:100',
                'banque' => 'required|string|max:255',
                'adresse_mail' => 'required|email|max:255',
                'adresse_site_internet' => 'required|string|max:255',
                'nom_president_association' => 'required|string|max:255',
                'tel_personnel' => 'required|string|max:50',
                'num_membre_bureau_national_a' => 'required|integer',
                'num_bureaux_regionaux' => 'required|integer',
                'num_total_membre' => 'required|integer',
                'types_financement' => 'required|array|min:1',
                'id_formulaire' => 'required|integer|exists:tp_type_formulaire,id_type',

                // Superviseur
                'nom_prenom_sup' => 'required|string|max:100',
                'profession_sup' => 'required|string|max:100',
                'role_sup'       => 'required|string|max:100',
                'tel_sup'        => 'required|string|max:12',
                'email_sup'      => 'required|email|max:255',

                // Projet
                'nom_projet'               => 'required|string|max:255',
                'justification_realisation'=> 'required|string|max:255',
                'objectives'               => 'required|string',
                'public'                   => 'required|string|max:255',
                'nombre_spectateur'        => 'required|integer|min:1',
                'tranch_age_min'           => 'required|integer|min:0',
                'tranch_age_max'           => 'required|integer|gte:tranch_age_min',
                'parties_realisation'      => 'required|string',
                'resultat_quantitatif'     => 'required|string',
                'resultat_qualitatif'      => 'required|string',
                'perspectives'             => 'required|string',

                // Phases
                'phases.*.description'         => 'required|string|max:200',
                'phases.*.completion_date'     => 'required|date',
                'phases.*.completion_location' => 'required|string|max:100',

                // Budget
                'budget.*.total_cost'      => 'required|numeric|min:0',
                'budget.*.self_percent'    => 'required|numeric|min:0|max:100',
                'budget.*.self_amount'     => 'required|numeric|min:0',
                'budget.*.ministry_amount' => 'required|numeric|min:0',
                'budget.*.ministry_percent'=> 'required|numeric|min:0|max:100',
                'budget.*.supporters.*.name'   => 'required|string|max:255',
                'budget.*.supporters.*.amount' => 'required|numeric|min:0',
                'budget.*.supporters.*.percent'=> 'required|numeric|min:0|max:100',

                // Dépenses
                'depenses.*.*.libelle_depense' => 'required|string|max:200',
                'depenses.*.*.description'     => 'required|string|max:255',
                'depenses.*.*.cout'            => 'required|numeric|min:0',

                // Documents
                'doc_fin.*.id_doc' => 'required|integer|exists:tp_type_document,id_type_doc',
                'doc_fin.*.file' => 'nullable|file|mimes:pdf,jpg,jpeg,png,doc,docx|max:2048',
                'doc_fin.*.remarques' => 'nullable|string|max:100',
            ];
        }

        $request->validate($rules);

        // Récupération du document et relations
        $docList = DocumentsFinancementList::findOrFail($id);
        $docList->brouillon = $isBrouillon ? 1 : 0;
        $docList->save();

        $projet = $docList->projet;
        $association = $projet->association;
        $superviseur = $projet->superviseur;

        // Mise à jour Association
        $association->update($request->only([
            'nom_association','adresse','code_postal','tel','fax',
            'date_creation','num_visa','date_visa','num_identification_fiscale',
            'num_compte_courant','banque','adresse_mail','adresse_site_internet',
            'nom_president_association','tel_personnel','num_membre_bureau_national_a',
            'num_bureaux_regionaux','num_total_membre','id_formulaire'
        ]));

        // Mise à jour Superviseur
        $superviseur->update($request->only([
            'nom_prenom_sup','profession_sup','role_sup','tel_sup','email_sup'
        ]));

        // Mise à jour Projet
        $projet->update([
            'id_formulaire'            => $request->id_formulaire,
            'nom_projet'               => $request->nom_projet,
            'justification_realisation'=> $request->justification_realisation,
            'objectives'               => $request->objectives,
            'public'                   => $request->public,
            'id_user'                  => auth()->id(),
            'nombre_spectateur'        => $request->nombre_spectateur,
            'tranch_age_min'           => $request->tranch_age_min,
            'tranch_age_max'           => $request->tranch_age_max,
            'parties_realisation'      => $request->parties_realisation,
            'resultat_quantitatif'     => $request->resultat_quantitatif,
            'resultat_qualitatif'      => $request->resultat_qualitatif,
            'perspectives'             => $request->perspectives,
        ]);

        // Supprimer et recréer les phases
        $projet->activites()->delete();
        if ($request->has('phases')) {
            foreach ($request->phases as $phase) {
                if (!empty($phase['description'])) {
                    ActivitePhase::create([
                        'id_projet'           => $projet->id_projet,
                        'description'         => $phase['description'],
                        'completion_date'     => $phase['completion_date'] ?? null,
                        'completion_location' => $phase['completion_location'] ?? null,
                    ]);
                }
            }
        }

        // Supprimer et recréer le budget
        if ($projet->estimationBudget && $projet->estimationBudget->count() > 0) {
            foreach ($projet->estimationBudget as $estimation) {
                $estimation->contributeurs()->delete();
                $estimation->postesDepense()->delete();
                $estimation->delete();
            }
        }

        if ($request->has('budget')) {
            foreach ($request->budget as $budget) {
                $estimation = EstimationBudget::create([
                    'projet_id'                      => $projet->id_projet,
                    'cout_total_estime'              => $budget['total_cost'] ?? 0,
                    'financement_propre_pourcentage' => $budget['self_percent'] ?? 0,
                    'financement_propre_montant'     => $budget['self_amount'] ?? 0,
                    'aide_ministere_montant'         => $budget['ministry_amount'] ?? 0,
                    'aide_ministere_pourcentage'     => $budget['ministry_percent'] ?? 0,
                ]);

                if (isset($budget['supporters'])) {
                    foreach ($budget['supporters'] as $supporter) {
                        if (!empty($supporter['name'])) {
                            ContributeurProjet::create([
                                'id_estimation_budget' => $estimation->id_estimation,
                                'nom'        => $supporter['name'],
                                'montant'    => $supporter['amount'] ?? 0,
                                'pourcentage'=> $supporter['percent'] ?? 0,
                            ]);
                        }
                    }
                }

                if ($request->has('depenses')) {
                    foreach ($request->depenses as $depense) {
                        if (!empty($depense['libelle_depense'])) {
                            PosteDepense::create([
                                'id_estimation_budget' => $estimation->id_estimation,
                                'libelle_depense'      => $depense['libelle_depense'],
                                'description'          => $depense['description'] ?? '',
                                'cout'                 => $depense['cout'] ?? 0,
                            ]);
                        }
                    }
                }
            }
        }

        // Documents
        if ($request->has('doc_fin')) {
            foreach ($request->doc_fin as $docData) {
                $doc = isset($docData['id_doc'])
                    ? DocumentsFinancement::where('id_doc_list', $docList->id_doc_list)
                                            ->where('id_doc', $docData['id_doc'])
                                            ->first()
                    : new DocumentsFinancement();

                if (isset($docData['file'])) {
                    $filePath = $docData['file']->store('documents_financement', 'public');
                    $doc->file = $filePath;
                }

                $doc->id_doc = $docData['id_doc'];
                $doc->remarques = $docData['remarques'] ?? null;
                $doc->id_doc_list = $docList->id_doc_list;
                $doc->save();
            }
        }

        DB::commit();

        return redirect()->route('doc_fin.brouillons', $docList->id_doc_list)
            ->with('success', 'تم تحديث الوثيقة بنجاح');

    } catch (\Exception $e) {
        DB::rollBack();
        return back()->withErrors(['error' => 'خطأ أثناء التحديث: ' . $e->getMessage()]);
    }
}

    public function destroy($id)
    {
        DB::beginTransaction();

        try {
            $docList = DocumentsFinancementList::with([
                'documents',
                'projet.superviseur',
                'projet.activites',
                'projet.estimationBudget.contributeurs',
                'projet.estimationBudget.postesDepense',
                'projet.demande',
                'projet.demande.association'
            ])->findOrFail($id);

            foreach ($docList->documents as $doc) {
                if ($doc->file && Storage::disk('public')->exists($doc->file)) {
                    Storage::disk('public')->delete($doc->file);
                }
                $doc->delete();
            }

            if ($docList->projet && $docList->projet->activites) {
                $docList->projet->activites()->delete();
            }

            if ($docList->projet && $docList->projet->estimationBudget) {
                foreach ($docList->projet->estimationBudget as $estimation) {
                    $estimation->contributeurs()->delete();
                    $estimation->postesDepense()->delete();
                    $estimation->delete();
                }
            }

            if ($docList->projet && $docList->projet->superviseur) {
                $docList->projet->superviseur->delete();
            }

            $projet = $docList->projet;
            if ($projet) {
                $projet->delete();
            }

            if ($projet && $projet->demande) {
                $association = $projet->demande->association;
                $projet->demande->delete();

                if ($association && $association->demandes()->count() == 0) {
                    $association->delete();
                }
            }

            $docList->delete();

            DB::commit();

            return redirect()->route('doc_fin.index')->with('success', 'تم حذف الوثيقة بنجاح');
        } catch (\Exception $e) {
            DB::rollBack();
            return back()->withErrors(['error' => 'حدث خطأ أثناء الحذف: ' . $e->getMessage()]);
        }
    }



public function toggleStatut(Request $request, $id, $field = 'id_statut1')
{
    $docList = DocumentsFinancementList::with(['user', 'projet'])->findOrFail($id);

    $allowedFields = ['id_statut1', 'id_statut2'];
    if (!in_array($field, $allowedFields)) {
        abort(400, 'Invalid status field');
    }

    // try multiple possible input names so UI can send either 'id_statut' or the actual field name
    $possibleInputs = ['id_statut', $field, str_replace('id_', '', $field), 'status'];
    $rawNew = null;
    foreach ($possibleInputs as $name) {
        if ($request->filled($name)) {
            $rawNew = $request->input($name);
            break;
        }
    }
    if ($rawNew === null && $request->has('id_statut')) {
        $rawNew = $request->input('id_statut');
    }
    if ($rawNew === null && $request->has($field)) {
        $rawNew = $request->input($field);
    }

    if ($rawNew === null) {
        \Log::warning("toggleStatut called without a usable status value for DocumentsFinancementList ID {$id}", [
            'request' => $request->all()
        ]);
        return redirect()->back()->with('error', 'الرجاء اختيار الحالة المراد تطبيقها.');
    }

    if (!is_numeric($rawNew)) {
        \Log::warning("toggleStatut received non-numeric status for DocumentsFinancementList ID {$id}", [
            'raw' => $rawNew
        ]);
        return redirect()->back()->with('error', 'القيمة المرسلة للوضعية غير صحيحة.');
    }
    $new = (int) $rawNew;

    // --- Robust comment detection (match keys sent by your JS and common fallbacks) ---
    $commentKeys = [
        'commentaire_refus',
        'commentaire_motif',
        'commentaire_status',
        'commentaire_acceptation',
        'commentaire_avis',
        'commentaire_motif1',
        'commentaire_motif2',
        'comment',
        'motif',
        'reason',
        'note'
    ];
    $comment = null;
    foreach ($commentKeys as $k) {
        if ($request->filled($k)) {
            $c = trim($request->input($k));
            if ($c !== '') {
                $comment = $c;
                break;
            }
        }
    }
    if ($comment === '') $comment = null;

    // Use ORIGINAL values for history comparisons
    $originalOld = (int) ($docList->getOriginal($field) ?? 0);
    $originalStat2 = (int) ($docList->getOriginal('id_statut2') ?? 0);

    // quick no-op check
    if ($originalOld === $new) {
        return redirect()->back()->with('info', 'No change.');
    }

    DB::beginTransaction();
    try {
        // Only change the allowed status fields on the model
        $docList->{$field} = $new > 0 ? $new : null;

        // business rule: when setting statut1 to accepted (1), set statut2 to 2
        if ($field === 'id_statut1' && $new === 1) {
            $docList->id_statut2 = 2;
        }

        // Persist the status changes (do NOT attempt to write commentaire_motif unless that column exists)
        $docList->save();

        // create history for the field that changed and include the comment detected from request
        ImmobilierStatutHistory::create([
            'documents_financement_list_id' => $docList->id_doc_list,
            'projet_id' => $docList->id_projet,
            'from_statut_id' => $originalOld > 0 ? $originalOld : null,
            'to_statut_id'   => $new > 0 ? $new : null,
            'changed_by'     => auth()->id() ?? null,
            'commentaire'    => $comment,
        ]);

        // if we set id_statut2 as a side-effect and its original value differs, write history for it too
        if ($field === 'id_statut1') {
            $currentStat2 = (int) ($docList->id_statut2 ?? 0);
            if ($originalStat2 !== $currentStat2) {
                ImmobilierStatutHistory::create([
                    'documents_financement_list_id' => $docList->id_doc_list,
                    'projet_id' => $docList->id_projet,
                    'from_statut_id' => $originalStat2 > 0 ? $originalStat2 : null,
                    'to_statut_id'   => $currentStat2 > 0 ? $currentStat2 : null,
                    'changed_by'     => auth()->id() ?? null,
                    'commentaire'    => $comment,
                ]);
            }
        }

        DB::commit();
    } catch (\Exception $e) {
        DB::rollBack();
        \Log::error("toggleStatut error for DocumentsFinancementList ID {$docList->id_doc_list}: " . $e->getMessage(), [
            'trace' => $e->getTraceAsString(),
            'request' => $request->all(),
        ]);
        return back()->withErrors(['error' => 'خطأ أثناء تغيير الحالة: ' . $e->getMessage()]);
    }

    // Notifications (best-effort) + Emails (unchanged behavior)
    try {
        $recipient = $docList->user ?? ($docList->projet->user ?? null);
        $email = null;
        if ($recipient) {
            $email = $recipient->email ?? $recipient->adresse_mail ?? null;
        }

        $resolved = (int) ($docList->{$field} ?? 0);
        $statusMap = [1 => 'accepted', 3 => 'rejected', 4 => 'incomplete', 5 => 'deferred'];
        $type = $statusMap[$resolved] ?? 'status_changed';

        $params = [];
        if ($resolved === 3) $params['reason'] = $comment ?? ($request->input('commentaire_refus') ?? '');
        if ($resolved === 4) $params['missing'] = $comment ?? ($request->input('commentaire_acceptation') ?? '');
        if ($resolved === 5) $params['note'] = $comment ?? ($request->input('commentaire_avis') ?? '');
        if ($resolved === 1) $params['date'] = now()->format('Y-m-d');
        if (!empty($comment)) $params['comment'] = $comment;

        if ($recipient) {
            $recipient->notify(new \App\Notifications\StatutDocumentNotification(
                $docList,
                $type,
                $params,
                $docList->id_doc_list
            ));
        }

        if ($email) {
            Mail::to($email)->send(new StatutDocumentChanged($docList, $type, $params, $recipient));
        }
    } catch (\Exception $ex) {
        \Log::error("Notification/email error in toggleStatut for docList {$docList->id_doc_list}: " . $ex->getMessage());
    }

    return redirect()->back()->with('success', 'تم تغيير الحالة بنجاح');
}

public function pdf($id)
{
    // Augmenter limites si nécessaire
    ini_set('pcre.backtrack_limit', '10000000');
    ini_set('pcre.recursion_limit', '10000000');
    ini_set('memory_limit', '512M');

    // Récupérer le document avec ses relations
    $docList = DocumentsFinancementList::with([
        'projet.superviseur',
        'projet.activites',
        'projet.estimationBudget',
        'projet.estimationBudget.contributeurs',
        'projet.estimationBudget.postesDepense',
        'documents',
        'documents.typeDocument',
        'statut1',
        'statut2'
    ])->findOrFail($id);

    $formulaire   = TypeFormulaire::find(6);
    $formulaire2  = TypeFormulaire::find(7);
    $formulaire3  = TypeFormulaire::find(8);
    $type_financement = TypeFinancement::all();

    $demande_id = $docList->projet->id_demande;
    $demande    = DemandeFinancement::with('association')->find($demande_id);

    $selectedAssociationId   = $demande && $demande->association ? $demande->association->id_association : null;
    $selectedAssociationName = $demande && $demande->association ? $demande->association->nom_association : null;

    $id_projet  = $docList->projet->id_projet;
    $documents  = $docList->documents;
    $typedocum  = TpTypeDocument::all();
    $selectedTypes = DemandeFinancement::where('association_id', $demande->association_id)
                                       ->pluck('type_financement_id')
                                       ->toArray();

  $lang = 'ar';
$direction = 'rtl';

    $html = view('backoffice.financement.documents_financement.pdf', compact(
        'docList','formulaire','formulaire2','formulaire3','type_financement',
        'demande_id','demande','selectedAssociationId','selectedAssociationName',
        'documents','id_projet','typedocum','selectedTypes',
        'lang','direction'
    ))->render();

    // Générer le PDF avec mPDF
    $mpdf = new \Mpdf\Mpdf([
        'mode'             => 'utf-8',
        'format'           => 'A4',
        'default_font'     => 'dejavusans',
        'directionality'   => $direction,
        'autoScriptToLang' => true,
        'autoLangToFont'   => true,
        'tempDir'          => storage_path('app/mpdf'),
    ]);

    $mpdf->setFooter('{PAGENO} / {nbpg}');
    $mpdf->WriteHTML($html);

    // Retourner la réponse PDF au navigateur
    return response(
        $mpdf->Output('document_financement_'.$id.'.pdf', 'S'),
        200,
        [
            'Content-Type'        => 'application/pdf',
            'Content-Disposition' => 'inline; filename="document_financement_'.$id.'.pdf"',
        ]
    );
}




}
