<?php

namespace App\Http\Controllers;

use App\Models\Builder;
use App\Models\BuilderContenu;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class BuilderController extends Controller
{
    public function index(Request $request)
    {
        $query = Builder::with('utilisateur');

        if ($request->filled('search')) {
            $query->where('titre_ar', 'like', '%' . $request->search . '%');
        }

        $builders = $query->orderBy('created_at','desc')->paginate(10);

        return view('backoffice.builder.index', compact('builders'));
    }

    public function create()
    {
        return view('backoffice.builder.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'titre_ar' => 'required|string|max:255',
            'titre_fr' => 'nullable|string|max:255',
            'titre_en' => 'nullable|string|max:255',

            'contenus.*.nature' => 'required|in:image,texte,video',
            'contenus.*.col' => 'required',
        ]);

        $builder = Builder::create([
            'titre_ar' => $request->titre_ar,
            'titre_fr' => $request->titre_fr,
            'titre_en' => $request->titre_en,
            'id_user' => Auth::id(),
        ]);

        foreach ($request->contenus as $item) {

            $data = [
                'id_builder' => $builder->id_builder,
                'nature' => $item['nature'],
                'col' => $item['col'],
            ];

            if ($item['nature'] == 'image' && isset($item['image'])) {
				$imageContent = file_get_contents($item['image']->getRealPath());
				$data['image'] = $imageContent;
			}

            if ($item['nature'] == 'video') {
                $data['url_video'] = $item['url_video'];
            }

            if ($item['nature'] == 'texte') {
                $data['text_ar'] = $item['text_ar'];
                $data['text_fr'] = $item['text_fr'];
                $data['text_en'] = $item['text_en'];
            }

            BuilderContenu::create($data);
        }

        return redirect()->route('builder.index')->with('success', 'تم الحفظ بنجاح');
    }

    public function edit($id)
    {
        $builder = Builder::with('contenus')->findOrFail($id);
        return view('backoffice.builder.edit', compact('builder'));
    }

    public function update(Request $request, $id)
{
    $builder = Builder::findOrFail($id);

    $request->validate([
        'titre_ar' => 'required|string|max:255',
        'titre_fr' => 'nullable|string|max:255',
        'titre_en' => 'nullable|string|max:255',
        'contenus.*.nature' => 'required|in:image,texte,video',
        'contenus.*.col' => 'required',
    ]);

    // Mise à jour du builder
    $builder->update([
        'titre_ar' => $request->titre_ar,
        'titre_fr' => $request->titre_fr,
        'titre_en' => $request->titre_en,
    ]);

    // IMPORTANT : clé primaire réelle
    $primary = 'id_builder_cont';

    $existing_ids = [];

    foreach ($request->contenus as $item) {

        // Ligne existante ?
        $contenu = null;

        if (!empty($item[$primary])) {
            $contenu = BuilderContenu::find($item[$primary]);
        }

        // Nouvelle ligne ?
        if (!$contenu) {
            $contenu = new BuilderContenu();
            $contenu->id_builder = $builder->id_builder;
        }

        // Champs communs
        $contenu->nature = $item['nature'];
        $contenu->col = $item['col'];

        // IMAGE
        if ($item['nature'] == 'image') {

			if (isset($item['image'])) {
				$imageContent = file_get_contents($item['image']->getRealPath());

				$contenu->image = $imageContent;
			}
		}


        // VIDEO
        if ($item['nature'] == 'video') {
            $contenu->url_video = $item['url_video'];
        }

        // TEXTE
        if ($item['nature'] == 'texte') {
            $contenu->text_ar = $item['text_ar'];
            $contenu->text_fr = $item['text_fr'];
            $contenu->text_en = $item['text_en'];
        }

        $contenu->save();

        // On garde les ID pour ne pas les supprimer
        $existing_ids[] = $contenu->$primary;
    }

    // SUPPRESSION DES LIGNES RETIRÉES
    BuilderContenu::where('id_builder', $builder->id_builder)
        ->whereNotIn($primary, $existing_ids)
        ->delete();

    return redirect()->route('builder.index')->with('success', 'تم التحديث بنجاح');
}


   /*     public function update(Request $request, $id)
{
    $builder = Builder::findOrFail($id);

    $request->validate([
        'titre_ar' => 'required|string|max:255',
        'titre_fr' => 'nullable|string|max:255',
        'titre_en' => 'nullable|string|max:255',
        'contenus.*.nature' => 'required|in:image,texte,video',
        'contenus.*.col' => 'required',
    ]);

    $builder->update([
        'titre_ar' => $request->titre_ar,
        'titre_fr' => $request->titre_fr,
        'titre_en' => $request->titre_en,
    ]);

    $existingIds = $builder->contenus->pluck('id_contenu')->toArray(); // Contenus existants

    foreach ($request->contenus as $item) {

        // Si id_contenu existe, on met à jour
        if (isset($item['id_contenu']) && in_array($item['id_contenu'], $existingIds)) {
            $contenu = BuilderContenu::find($item['id_contenu']);
            $contenu->nature = $item['nature'];
            $contenu->col = $item['col'];

            if ($item['nature'] == 'image') {
                if (isset($item['image'])) {
                    $img = $item['image']->store('builder', 'public');
                    $contenu->image = $img;
                }
            } elseif ($item['nature'] == 'video') {
                $contenu->url_video = $item['url_video'] ?? $contenu->url_video;
                $contenu->image = null;
                $contenu->text_ar = $contenu->text_fr = $contenu->text_en = null;
            } elseif ($item['nature'] == 'texte') {
                $contenu->text_ar = $item['text_ar'] ?? $contenu->text_ar;
                $contenu->text_fr = $item['text_fr'] ?? $contenu->text_fr;
                $contenu->text_en = $item['text_en'] ?? $contenu->text_en;
                $contenu->image = null;
                $contenu->url_video = null;
            }

            $contenu->save();

        } else {
            // Nouvelle ligne
            $data = [
                'id_builder' => $builder->id_builder,
                'nature' => $item['nature'],
                'col' => $item['col'],
            ];

            if ($item['nature'] == 'image' && isset($item['image'])) {
                $img = $item['image']->store('builder', 'public');
                $data['image'] = $img;
            }
            if ($item['nature'] == 'video') {
                $data['url_video'] = $item['url_video'];
            }
            if ($item['nature'] == 'texte') {
                $data['text_ar'] = $item['text_ar'];
                $data['text_fr'] = $item['text_fr'];
                $data['text_en'] = $item['text_en'];
            }

            BuilderContenu::create($data);
        }
    }

    return redirect()->route('builder.index')->with('success', 'تم التحديث بنجاح');
}*/



    public function destroy($id)
    {
        $builder = Builder::findOrFail($id);
        BuilderContenu::where('id_builder', $builder->id_builder)->delete();
        $builder->delete();

        return redirect()->route('builder.index')->with('success', 'تم الحذف بنجاح');
    }

}
