<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\MilieuAuberge;
use App\Models\Auberge;
use App\Models\Gouvernorat;
use App\Models\TpSportsAuberge;
use App\Models\TpServiceAuberge;
use App\Models\Delegation;
use App\Models\RestaurationAuberge;
use App\Models\TypeChambre;
use App\Models\ChambreTente;
class AubergesController extends Controller
{
    public function index()
	{
		$auberges = Auberge::with(['gouvernorat', 'delegation'])
							->paginate(10); 

		return view('backoffice.auberges.creation_centre.index', compact('auberges'));
	}

    public function create()
    {
        $milieux = MilieuAuberge::all();
        $gouvernorats = Gouvernorat::all();
        $sports = TpSportsAuberge::all();
        $services = TpServiceAuberge::all();
        $typesChambres = TypeChambre::all();

        return view('backoffice.auberges.creation_centre.create', compact('milieux','gouvernorats','sports','services','typesChambres'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'nom' => 'required|string|max:255',
            'contact_tel' => 'required|string|max:50',
            'contact_email' => 'required|email|max:255',
            'gouvernorat_id' => 'required|integer',
            'delegation_id' => 'required|integer',
            'epa' => 'required|string|in:EPA,Non EPA',
            'id_milieu_auberge' => 'required|integer',
            'adresse' => 'required|string|max:255',
            'code_postal' => 'required|string|max:20',
            'nom_directeur' => 'required|string|max:255',
            'tel_directeur' => 'required|string|max:50',
            'espace_boisson' => 'required|boolean',
            'piscine' => 'required|boolean',
            'espace_tv_web' => 'sometimes|boolean',
            'espace_radio_web' => 'sometimes|boolean',
            'espace_gaming' => 'sometimes|boolean',
            'cuisine_fonctionnelle' => 'sometimes|boolean',
            'capacite_batiment' => 'required|integer',
            'nb_chambres' => 'required|integer',
            'nb_chambres_single' => 'required|integer',
            'nb_chambres_double' => 'required|integer',
            'nb_chambres_triple' => 'required|integer',
            'nb_chambres_quadra' => 'required|integer',
            'nb_chambres_plus' => 'required|integer',
            'nb_salles_de_bain' => 'required|integer',
            'nb_salles_de_bain_comm' => 'required|integer',
            'nb_chambres_tv' => 'required|integer',
            'nb_chambres_clim' => 'required|integer',
            'nb_chambres_frigo' => 'required|integer',
            'capacite_tentes' => 'required|integer',
            'lieux_culturels' => 'nullable|string',
            'autres_services' => 'nullable|string',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,webp|max:2048',
            'description' => 'required|string|max:500',
            'latitude' => 'required|string|max:50',
            'longitude' => 'required|string|max:50',
            'prix_lit' => 'required|numeric|min:0',

           'restaurations' => 'required|array|min:1',
            'restaurations.*.nom_fr' => 'required|string|max:255',
            'restaurations.*.nom_ar' => 'required|string|max:255',
            'restaurations.*.nom_en' => 'required|string|max:255',
            'restaurations.*.description_fr' => 'nullable|string',
            'restaurations.*.description_ar' => 'nullable|string',
            'restaurations.*.description_en' => 'nullable|string',
            'restaurations.*.tarif' => 'required|numeric|min:0',

            'chambres' => 'required|array|min:1',
            'chambres.*.type_chambre_id' => 'required|integer|exists:tp_type_chambre,id_type',
            'chambres.*.capacite' => 'required|integer|min:1',
            'chambres.*.num_chambre' => 'required|integer|min:1',

        ]);

       
        $auberge = Auberge::create([
            'nom' => $request->nom,
            'contact_tel' => $request->contact_tel,
            'contact_email' => $request->contact_email,
            'gouver_id' => $request->gouvernorat_id,
            'delegation_id' => $request->delegation_id,
            'epa' => $request->epa,
            'id_milieu_auberge' => $request->id_milieu_auberge,
            'coordonnees' => $request->coordonnees,
            'fax' => $request->fax,
            'code_postal' => $request->code_postal,
            'adresse' => $request->adresse,
            'nom_directeur' => $request->nom_directeur,
            'tel_directeur' => $request->tel_directeur,
            'espace_boisson' => $request->has('espace_boisson') ? 1 : 0,
            'piscine' => $request->has('piscine') ? 1 : 0,

            'espace_tv_web' => $request->has('espace_tv_web') ? 1 : 0,
            'espace_radio_web' => $request->has('espace_radio_web') ? 1 : 0,
            'espace_gaming' => $request->has('espace_gaming') ? 1 : 0,
            'capacite_batiment' => $request->capacite_batiment,
            'nb_chambres' => $request->nb_chambres,
            'nb_chambres_single' => $request->nb_chambres_single,
            'nb_chambres_double' => $request->nb_chambres_double,
            'nb_chambres_triple' => $request->nb_chambres_triple,
            'nb_chambres_quadra' => $request->nb_chambres_quadra,
            'nb_chambres_plus' => $request->nb_chambres_plus,
            'nb_salles_de_bain' => $request->nb_salles_de_bain,
            'nb_salles_de_bain_comm' => $request->nb_salles_de_bain_comm,
            'nb_chambres_tv' => $request->nb_chambres_tv,
            'nb_chambres_clim' => $request->nb_chambres_clim,
            'nb_chambres_frigo' => $request->nb_chambres_frigo,
            'capacite_tentes' => $request->capacite_tentes,
            'cuisine_fonct' => $request->has('cuisine_fonctionnelle') ? 1 : 0,
            'lieux_culturels' => $request->lieux_culturels,
            'autres_services' => $request->autres_services,
            'description' => $request->description,
            'latitude' => $request->latitude,
            'longitude' => $request->longitude,
            'prix_lit'=> $request->prix_lit,
        ]);

        if ($request->has('restaurations')) {
            foreach ($request->restaurations as $restaurationData) {
                RestaurationAuberge::create([
                    'auberge_id' => $auberge->id,
                    'nom_fr' => $restaurationData['nom_fr'],
                    'nom_ar' => $restaurationData['nom_ar'],
                    'nom_en' => $restaurationData['nom_en'],
                    'description_fr' => $restaurationData['description_fr'] ?? null,
                    'description_ar' => $restaurationData['description_ar'] ?? null,
                    'description_en' => $restaurationData['description_en'] ?? null,
                    'tarif' => $restaurationData['tarif'],
                ]);
            }
        }


        if ($request->has('sports')) {
            $auberge->sports()->sync($request->sports);
        }

        if ($request->has('services')) {
            $auberge->services()->sync($request->services);
        }

        if ($request->hasFile('image')) {
            $imagePath = $request->file('image')->store('uploads/images/auberges', 'public');
            $auberge->image = $imagePath;
            $auberge->save();
        }

        if ($request->has('chambres')) {
            foreach ($request->chambres as $chambreData) {
                ChambreTente::create([
                    'auberge_id' => $auberge->id,
                    'type_chambre_id' => $chambreData['type_chambre_id'],
                    'capacite' => $chambreData['capacite'],
                    'num_chambre' => $chambreData['num_chambre'],
                    'type' => 'chambre',
                ]);
            }
        }

        return redirect()->route('auberges.index')
                        ->with('success', 'تمت إضافة المركب أو مركز الإقامة بنجاح !');
    }

    public function edit($id)
    {
        $auberge = Auberge::findOrFail($id);
        $milieux = MilieuAuberge::all();
        $gouvernorats = Gouvernorat::all();
        $delegations = Delegation::all();
        $sports = TpSportsAuberge::all();
        $services = TpServiceAuberge::all();
        $typesChambres = TypeChambre::all();

        return view('backoffice.auberges.creation_centre.edit', compact(
            'auberge','milieux','gouvernorats','sports','services','delegations','typesChambres'
        ));
    }

    public function update(Request $request, $id)
    {
        $auberge = Auberge::findOrFail($id);
        $request->validate([
            'nom' => 'required|string|max:255',
            'contact_tel' => 'required|string|max:50',
            'contact_email' => 'required|email|max:255',
            'gouvernorat_id' => 'required|integer',
            'delegation_id' => 'required|integer',
            'epa' => 'required|string|in:EPA,Non EPA',
            'id_milieu_auberge' => 'required|integer',
            'adresse' => 'required|string|max:255',
            'code_postal' => 'required|string|max:20',
            'nom_directeur' => 'required|string|max:255',
            'tel_directeur' => 'required|string|max:50',
            'espace_boisson' => 'required|boolean',
            'piscine' => 'required|boolean',
            'espace_tv_web' => 'sometimes|boolean',
            'espace_radio_web' => 'sometimes|boolean',
            'espace_gaming' => 'sometimes|boolean',
            'cuisine_fonctionnelle' => 'sometimes|boolean',
            'capacite_batiment' => 'required|integer',
            'nb_chambres' => 'required|integer',
            'nb_chambres_single' => 'required|integer',
            'nb_chambres_double' => 'required|integer',
            'nb_chambres_triple' => 'required|integer',
            'nb_chambres_quadra' => 'required|integer',
            'nb_chambres_plus' => 'required|integer',
            'nb_salles_de_bain' => 'required|integer',
            'nb_salles_de_bain_comm' => 'required|integer',
            'nb_chambres_tv' => 'required|integer',
            'nb_chambres_clim' => 'required|integer',
            'nb_chambres_frigo' => 'required|integer',
            'capacite_tentes' => 'required|integer',
            'lieux_culturels' => 'nullable|string',
            'autres_services' => 'nullable|string',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,webp|max:2048',
            'description' => 'required|string|max:500',
            'latitude' => 'required|string|max:50',
            'longitude' => 'required|string|max:50',
            'prix_lit' => 'required|numeric|min:0',

            'restaurations' => 'nullable|array',
            'restaurations.*.id_rest' => 'nullable|integer|exists:restaurations_auberge,id_rest',
            'restaurations.*.nom_fr' => 'required|string|max:255',
            'restaurations.*.nom_ar' => 'required|string|max:255',
            'restaurations.*.nom_en' => 'required|string|max:255',
            'restaurations.*.description_fr' => 'nullable|string',
            'restaurations.*.description_ar' => 'nullable|string',
            'restaurations.*.description_en' => 'nullable|string',
            'restaurations.*.tarif' => 'required|numeric|min:0',

            'chambres' => 'required|array|min:1',
            'chambres.*.type_chambre_id' => 'required|integer|exists:tp_type_chambre,id_type',
            'chambres.*.capacite' => 'required|integer|min:1',
            'chambres.*.num_chambre' => 'required|integer|min:1',
        ]);

        $auberge->update([
            'nom' => $request->nom,
            'contact_tel' => $request->contact_tel,
            'contact_email' => $request->contact_email,
            'gouver_id' => $request->gouvernorat_id,
            'delegation_id' => $request->delegation_id,
            'epa' => $request->epa,
            'id_milieu_auberge' => $request->id_milieu_auberge,
            'coordonnees' => $request->coordonnees,
            'fax' => $request->fax,
            'code_postal' => $request->code_postal,
            'adresse' => $request->adresse,
            'nom_directeur' => $request->nom_directeur,
            'tel_directeur' => $request->tel_directeur,
            'espace_boisson' => $request->has('espace_boisson') ? 1 : 0,
            'piscine' => $request->has('piscine') ? 1 : 0,
            'espace_tv_web' => $request->has('espace_tv_web') ? 1 : 0,
            'espace_radio_web' => $request->has('espace_radio_web') ? 1 : 0,
            'espace_gaming' => $request->has('espace_gaming') ? 1 : 0,
            'capacite_batiment' => $request->capacite_batiment,
            'nb_chambres' => $request->nb_chambres,
            'nb_chambres_single' => $request->nb_chambres_single,
            'nb_chambres_double' => $request->nb_chambres_double,
            'nb_chambres_triple' => $request->nb_chambres_triple,
            'nb_chambres_quadra' => $request->nb_chambres_quadra,
            'nb_chambres_plus' => $request->nb_chambres_plus,
            'nb_salles_de_bain' => $request->nb_salles_de_bain,
            'nb_salles_de_bain_comm' => $request->nb_salles_de_bain_comm,
            'nb_chambres_tv' => $request->nb_chambres_tv,
            'nb_chambres_clim' => $request->nb_chambres_clim,
            'nb_chambres_frigo' => $request->nb_chambres_frigo,
            'capacite_tentes' => $request->capacite_tentes,
            'cuisine_fonct' => $request->has('cuisine_fonctionnelle') ? 1 : 0,
            'lieux_culturels' => $request->lieux_culturels,
            'autres_services' => $request->autres_services,
            'description' => $request->description,
            'latitude' => $request->latitude,
            'longitude' => $request->longitude,
            'prix_lit'=> $request->prix_lit,
        ]);

        if ($request->has('restaurations')) {
            foreach ($request->restaurations as $restaurationData) {
                if (!empty($restaurationData['id_rest'])) {
                    RestaurationAuberge::where('id_rest', $restaurationData['id_rest'])
                        ->update([
                            'nom_fr' => $restaurationData['nom_fr'],
                            'nom_ar' => $restaurationData['nom_ar'],
                            'nom_en' => $restaurationData['nom_en'],
                            'description_fr' => $restaurationData['description_fr'] ?? null,
                            'description_ar' => $restaurationData['description_ar'] ?? null,
                            'description_en' => $restaurationData['description_en'] ?? null,
                            'tarif' => $restaurationData['tarif'],
                        ]);
                } 
                else {
                    RestaurationAuberge::create([
                        'auberge_id' => $auberge->id,
                        'nom_fr' => $restaurationData['nom_fr'],
                        'nom_ar' => $restaurationData['nom_ar'],
                        'nom_en' => $restaurationData['nom_en'],
                        'description_fr' => $restaurationData['description_fr'] ?? null,
                        'description_ar' => $restaurationData['description_ar'] ?? null,
                        'description_en' => $restaurationData['description_en'] ?? null,
                        'tarif' => $restaurationData['tarif'],
                    ]);
                }

            }
        }

        if ($request->has('chambres')) {

            foreach ($request->chambres as $ch) {

                if (!empty($ch['id_chambre_tente'])) {
                    chambreTente::where('id_chambre_tente', $ch['id_chambre_tente'])
                        ->update([
                            'type_chambre_id' => $ch['type_chambre_id'],
                            'capacite' => $ch['capacite'],
                            'num_chambre' => $ch['num_chambre'],
                        ]);
                }
                else {
                    ChambreTente::create([
                        'auberge_id' => $auberge->id,
                        'type_chambre_id' => $ch['type_chambre_id'],
                        'capacite' => $ch['capacite'],
                        'num_chambre' => $ch['num_chambre'],
                        'type' => 'chambre',
                    ]);
                }
            }
        }


        if ($request->has('sports')) {
            $auberge->sports()->sync($request->sports);
        } else {
            $auberge->sports()->sync([]);
        }

        if ($request->has('services')) {
            $auberge->services()->sync($request->services);
        } else {
            $auberge->services()->sync([]);
        }

            if ($request->hasFile('image')) {
                $imagePath = $request->file('image')->store('uploads/images/auberges', 'public');

                $auberge->image = $imagePath;
                $auberge->save();
            }


        return redirect()->route('auberges.index')
                        ->with('success', 'تم تحديث بيانات المركب أو مركز الإقامة بنجاح !');
    }

    public function show($id)
    {
        $auberge = Auberge::findOrFail($id);
        $milieux = MilieuAuberge::all();
        $gouvernorats = Gouvernorat::all();
        $delegations = Delegation::all();
        $sports = TpSportsAuberge::all();
        $services = TpServiceAuberge::all();
        $typesChambres = TypeChambre::all();

        return view('backoffice.auberges.creation_centre.show', compact(
            'auberge','milieux','gouvernorats','sports','services','delegations','typesChambres'
        ));
    }

    public function destroy($id)
    {
        $auberge = Auberge::findOrFail($id);

        try {
            $auberge->delete();
            return redirect()->route('auberges.index')->with('success', 'تم الحذف بنجاح');
        } catch (\Exception $e) {
            return redirect()->route('auberges.index')->with('error', 'حدث خطأ أثناء الحذف');
        }
    }
	
	
	public function getDelegations_auberge($gouvernoratId)

    {

        $delegations = Delegation::where('gouver_id', $gouvernoratId)->get();

        return response()->json($delegations);

    }


}